/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/rust/ide/formatter/RsFormattingUtils;", "", "<init>", "()V", "getSpaceIndent", "", "file", "Lcom/intellij/psi/PsiFile;", "node", "Lcom/intellij/lang/ASTNode;", "intellij.rustrover.core"})
public final class RsFormattingUtils {
    @NotNull
    public static final RsFormattingUtils INSTANCE = new RsFormattingUtils();

    private RsFormattingUtils() {
    }

    public final int getSpaceIndent(@NotNull PsiFile file, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int indent = IndentHelper.getInstance().getIndent(file, node);
        int tabs = indent / 10000;
        int spaces = indent - tabs * 10000;
        int tabSpaces = CodeStyle.getIndentOptions((PsiFile)file).INDENT_SIZE * tabs;
        return tabSpaces + spaces;
    }
}

