/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes.createFromUsage;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.fixes.createFromUsage.CreateEnumVariantFixKt;
import org.rust.ide.fixes.createFromUsage.CreateStructFix;
import org.rust.ide.fixes.createFromUsage.CreateTupleStructFix;
import org.rust.ide.utils.PsiInsertionPlace;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsEnumBody;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructLiteral;
import org.rust.lang.core.psi.ext.PathResolveStatus;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsEnumItemKt;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.lang.core.resolve.ref.RsPathReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u001b\u001cB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/rust/ide/fixes/createFromUsage/CreateEnumVariantFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsElement;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "element", "Lorg/rust/lang/core/psi/ext/RsReferenceElement;", "name", "", "ctx", "Lorg/rust/ide/fixes/createFromUsage/CreateEnumVariantFix$Context;", "<init>", "(Lorg/rust/lang/core/psi/ext/RsReferenceElement;Ljava/lang/String;Lorg/rust/ide/fixes/createFromUsage/CreateEnumVariantFix$Context;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "generateFields", "path", "Lorg/rust/lang/core/psi/RsPath;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "Context", "Companion", "intellij.rustrover.core"})
public final class CreateEnumVariantFix
extends RsQuickFixBase<RsElement>
implements LowPriorityAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Context ctx;

    public CreateEnumVariantFix(@NotNull RsReferenceElement element, @NotNull String name2, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super((PsiElement)element);
        this.name = name2;
        this.ctx = ctx;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.create.enum.variant", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.name};
        return RsBundle.INSTANCE.message("intention.name.create.enum.variant", objectArray);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
        String fields = this.generateFields(this.ctx.getPath());
        RsEnumVariant variant = factory2.createEnumVariant(this.ctx.getName() + fields);
        PsiInsertionPlace psiInsertionPlace = this.ctx.getCommaPlace();
        if (psiInsertionPlace != null) {
            psiInsertionPlace.insert(factory2.createComma());
        }
        PsiElement[] psiElementArray = new PsiElement[]{variant, factory2.createComma(), factory2.createNewline()};
        this.ctx.getPlace().insertMultiple(psiElementArray);
    }

    private final String generateFields(RsPath path) {
        PsiElement context2;
        PsiElement context = path.getContext();
        if (context instanceof RsStructLiteral) {
            return StringsKt.replace$default((String)CreateStructFix.Companion.generateFields((RsStructLiteral)context, ""), (char)'\n', (char)' ', (boolean)false, (int)4, null);
        }
        PsiElement psiElement2 = context;
        Object object = context2 = psiElement2 != null ? psiElement2.getContext() : null;
        if (context instanceof RsPathExpr && context2 instanceof RsCallExpr) {
            return CreateTupleStructFix.Companion.generateFields((RsCallExpr)context2, "");
        }
        return "";
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/fixes/createFromUsage/CreateEnumVariantFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/createFromUsage/CreateEnumVariantFix;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCreateEnumVariantFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateEnumVariantFix.kt\norg/rust/ide/fixes/createFromUsage/CreateEnumVariantFix$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1761#2,3:87\n1#3:90\n*S KotlinDebug\n*F\n+ 1 CreateEnumVariantFix.kt\norg/rust/ide/fixes/createFromUsage/CreateEnumVariantFix$Companion\n*L\n72#1:87,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CreateEnumVariantFix createIfCompatible(@NotNull PsiElement element) {
            RsEnumBody rsEnumBody;
            PsiInsertionPlace commaPlace;
            Object lastVariant;
            Object object;
            Object it2;
            Object object2;
            boolean bl;
            RsEnumItem rsEnumItem;
            String name2;
            RsPath path;
            block18: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                RsPath rsPath = element instanceof RsPath ? (RsPath)element : null;
                if (rsPath == null) {
                    return null;
                }
                path = rsPath;
                if (path.getContext() instanceof RsPath) {
                    return null;
                }
                if (RsPathKt.getResolveStatus(path) != PathResolveStatus.UNRESOLVED) {
                    return null;
                }
                String string = path.getReferenceName();
                if (string == null) {
                    return null;
                }
                name2 = string;
                if (((CharSequence)name2).length() == 0 || Character.isLowerCase(StringsKt.first((CharSequence)name2))) {
                    return null;
                }
                RsPath rsPath2 = RsPathKt.getQualifier(path);
                if (rsPath2 == null) {
                    return null;
                }
                RsPath qualifier = rsPath2;
                RsPathReference rsPathReference = qualifier.getReference();
                RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
                RsEnumItem rsEnumItem2 = rsElement instanceof RsEnumItem ? (RsEnumItem)rsElement : null;
                if (rsEnumItem2 == null) {
                    return null;
                }
                rsEnumItem = rsEnumItem2;
                Iterable $this$any$iv = RsEnumItemKt.getVariants(rsEnumItem);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    object2 = $this$any$iv.iterator();
                    while (object2.hasNext()) {
                        Object element$iv = object2.next();
                        RsEnumVariant it3 = (RsEnumVariant)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it3.getName(), (Object)name2)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            RsEnumVariant rsEnumVariant = (RsEnumVariant)CollectionsKt.lastOrNull(RsEnumItemKt.getVariants(rsEnumItem));
            if (rsEnumVariant != null) {
                it2 = object2 = rsEnumVariant;
                boolean bl3 = false;
                object = !CreateEnumVariantFixKt.access$getHasTrailingComma((RsEnumVariant)it2) ? object2 : null;
            } else {
                object = null;
            }
            Object object3 = lastVariant = object;
            if (object3 != null) {
                it2 = object3;
                boolean bl4 = false;
                v9 = PsiInsertionPlace.Companion.after((PsiElement)it2);
                if (v9 == null) {
                    return null;
                }
            } else {
                v9 = commaPlace = null;
            }
            if ((rsEnumBody = rsEnumItem.getEnumBody()) == null || (rsEnumBody = rsEnumBody.getRbrace()) == null) {
                return null;
            }
            RsEnumBody rbrace = rsEnumBody;
            PsiInsertionPlace psiInsertionPlace = PsiInsertionPlace.Companion.before(rbrace);
            if (psiInsertionPlace == null) {
                return null;
            }
            PsiInsertionPlace place = psiInsertionPlace;
            return new CreateEnumVariantFix(path, name2, new Context(path, rsEnumItem, name2, place, commaPlace));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/fixes/createFromUsage/CreateEnumVariantFix$Context;", "", "path", "Lorg/rust/lang/core/psi/RsPath;", "enum", "Lorg/rust/lang/core/psi/RsEnumItem;", "name", "", "place", "Lorg/rust/ide/utils/PsiInsertionPlace;", "commaPlace", "<init>", "(Lorg/rust/lang/core/psi/RsPath;Lorg/rust/lang/core/psi/RsEnumItem;Ljava/lang/String;Lorg/rust/ide/utils/PsiInsertionPlace;Lorg/rust/ide/utils/PsiInsertionPlace;)V", "getPath", "()Lorg/rust/lang/core/psi/RsPath;", "getEnum", "()Lorg/rust/lang/core/psi/RsEnumItem;", "getName", "()Ljava/lang/String;", "getPlace", "()Lorg/rust/ide/utils/PsiInsertionPlace;", "getCommaPlace", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsPath path;
        @NotNull
        private final RsEnumItem enum;
        @NotNull
        private final String name;
        @NotNull
        private final PsiInsertionPlace place;
        @Nullable
        private final PsiInsertionPlace commaPlace;

        public Context(@NotNull RsPath path, @NotNull RsEnumItem rsEnumItem, @NotNull String name2, @NotNull PsiInsertionPlace place, @Nullable PsiInsertionPlace commaPlace) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)rsEnumItem, (String)"enum");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            this.path = path;
            this.enum = rsEnumItem;
            this.name = name2;
            this.place = place;
            this.commaPlace = commaPlace;
        }

        @NotNull
        public final RsPath getPath() {
            return this.path;
        }

        @NotNull
        public final RsEnumItem getEnum() {
            return this.enum;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final PsiInsertionPlace getPlace() {
            return this.place;
        }

        @Nullable
        public final PsiInsertionPlace getCommaPlace() {
            return this.commaPlace;
        }
    }
}

