/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B+\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/fixes/SubstituteTextFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/project/DumbAware;", "fixName", "", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "substitution", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "fileWithRange", "Lcom/intellij/psi/SmartPsiFileRange;", "Lorg/jetbrains/annotations/NotNull;", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
public abstract class SubstituteTextFix
extends RsQuickFixBase<PsiElement>
implements DumbAware {
    @NotNull
    private final String fixName;
    @Nullable
    private final String substitution;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiFileRange fileWithRange;

    public SubstituteTextFix(@IntentionName @NotNull String fixName, @NotNull PsiElement element, @NotNull TextRange range, @Nullable String substitution) {
        Intrinsics.checkNotNullParameter((Object)fixName, (String)"fixName");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(element);
        this.fixName = fixName;
        this.substitution = substitution;
        SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiFileRangePointer(element.getContainingFile(), range);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        this.fileWithRange = smartPsiFileRange;
    }

    public /* synthetic */ SubstituteTextFix(String string, PsiElement psiElement2, TextRange textRange, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = RsBundle.INSTANCE.message("intention.name.substitute", new Object[0]);
        }
        this(string, psiElement2, textRange, string2);
    }

    @Override
    @NotNull
    public String getText() {
        return this.fixName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.substitute.one.text.to.another", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Segment segment = this.fileWithRange.getRange();
        if (segment == null) {
            return;
        }
        Segment range = segment;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Document document = UtilsKt.getDocument(psiFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        if (this.substitution != null) {
            document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)this.substitution);
        } else {
            document2.deleteString(range.getStartOffset(), range.getEndOffset());
        }
    }
}

