/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.intentions.util.macros.IntentionInMacroUtil;
import org.rust.ide.refactoring.ExtraxtExpressionUiKt;
import org.rust.lang.core.psi.RsLabel;
import org.rust.lang.core.psi.RsLabelDecl;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsLabelReferenceOwner;
import org.rust.lang.core.psi.ext.RsLooplikeExpr;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/fixes/RsRenameLabelFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsLabelReferenceOwner;", "element", "<init>", "(Lorg/rust/lang/core/psi/ext/RsLabelReferenceOwner;)V", "getFamilyName", "", "getText", "startInWriteAction", "", "availableInBatchMode", "getElementToMakeWritable", "Lcom/intellij/psi/PsiFile;", "currentFile", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.rustrover.core"})
public final class RsRenameLabelFix
extends RsQuickFixBase<RsLabelReferenceOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private RsRenameLabelFix(RsLabelReferenceOwner element) {
        super((PsiElement)element);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.rename.label", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean availableInBatchMode() {
        return false;
    }

    @NotNull
    public PsiFile getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return currentFile;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsLabelReferenceOwner element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UtilsKt.checkWriteAccessNotAllowed();
        if (editor2 == null) {
            return;
        }
        RsLabel rsLabel = element.getLabel();
        if (rsLabel == null) {
            return;
        }
        RsLabel label = rsLabel;
        List labelDecls = RsRenameLabelFix.Companion.labelDecls(element);
        if (labelDecls.isEmpty()) {
            return;
        }
        if (labelDecls.size() == 1 || UtilsKt.isUnitTestMode()) {
            RsRenameLabelFix.invoke$runCommand(project, this, editor2, (RsLabelDecl)CollectionsKt.first((List)labelDecls), label);
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor2, (List)labelDecls, ExtraxtExpressionUiKt.getAsPass(arg_0 -> RsRenameLabelFix.invoke$lambda$1(label, project, this, editor2, arg_0)), arg_0 -> RsRenameLabelFix.invoke$lambda$3(RsRenameLabelFix::invoke$lambda$2, arg_0), (String)RsBundle.INSTANCE.message("popup.title.rename.label", new Object[0]));
        }
    }

    private static final void invoke$runCommand(Project $project, RsRenameLabelFix this$0, Editor $editor, RsLabelDecl labelDecl, RsLabel label) {
        UtilsKt.runWriteCommandAction($project, this$0.getText(), new PsiFile[0], () -> RsRenameLabelFix.invoke$runCommand$lambda$0(labelDecl, $project, label, $editor));
    }

    private static final Unit invoke$runCommand$lambda$0(RsLabelDecl $labelDecl, Project $project, RsLabel $label, Editor $editor) {
        String string = $labelDecl.getName();
        if (string == null) {
            return Unit.INSTANCE;
        }
        String name2 = string;
        PsiElement newLabel = new RsPsiFactory($project, false, false, 6, null).createQuoteIdentifier(name2);
        $label.getReferenceNameElement().replace(newLabel);
        IntentionInMacroUtil.INSTANCE.finishActionInMacroExpansionCopy($editor);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$1(RsLabel $label, Project $project, RsRenameLabelFix this$0, Editor $editor, RsLabelDecl labelDecl) {
        Intrinsics.checkNotNullParameter((Object)labelDecl, (String)"labelDecl");
        RsRenameLabelFix.invoke$runCommand($project, this$0, $editor, labelDecl, $label);
        return Unit.INSTANCE;
    }

    private static final String invoke$lambda$2(RsLabelDecl it2) {
        return " " + it2.getName();
    }

    private static final String invoke$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    public /* synthetic */ RsRenameLabelFix(RsLabelReferenceOwner element, DefaultConstructorMarker $constructor_marker) {
        this(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/fixes/RsRenameLabelFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/RsRenameLabelFix;", "element", "Lorg/rust/lang/core/psi/ext/RsLabelReferenceOwner;", "labelDecls", "", "Lorg/rust/lang/core/psi/RsLabelDecl;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsRenameLabelFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsRenameLabelFix.kt\norg/rust/ide/fixes/RsRenameLabelFix$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1617#2,9:80\n1869#2:89\n1870#2:91\n1626#2:92\n1#3:90\n*S KotlinDebug\n*F\n+ 1 RsRenameLabelFix.kt\norg/rust/ide/fixes/RsRenameLabelFix$Companion\n*L\n76#1:80,9\n76#1:89\n76#1:91\n76#1:92\n76#1:90\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RsRenameLabelFix createIfCompatible(@NotNull RsLabelReferenceOwner element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (this.labelDecls(element).isEmpty()) {
                return null;
            }
            return new RsRenameLabelFix(element, null);
        }

        /*
         * WARNING - void declaration
         */
        private final List<RsLabelDecl> labelDecls(RsLabelReferenceOwner $this$labelDecls) {
            void $this$mapNotNullTo$iv$iv;
            List list = PsiTreeUtil.collectParents((PsiElement)$this$labelDecls, RsLooplikeExpr.class, (boolean)false, arg_0 -> Companion.labelDecls$lambda$1(Companion::labelDecls$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectParents(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                RsLabelDecl it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                RsLooplikeExpr it2 = (RsLooplikeExpr)element$iv$iv;
                boolean bl2 = false;
                if (it2.getLabelDecl() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static final boolean labelDecls$lambda$0(PsiElement it2) {
            return it2 instanceof RsItemElement;
        }

        private static final boolean labelDecls$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

