/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.intentions.util.macros.IntentionInMacroUtil;
import org.rust.ide.statistics.IntentionPlace;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\u000fH&J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J'\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001aJ3\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0086\u0002J*\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0002H\u0002J&\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002J)\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0086\u0002J0\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002J\u0006\u0010$\u001a\u00020\u0015J\u0012\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020\u001cH\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u001cH\u0016J\u0016\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-J\n\u0010.\u001a\u0004\u0018\u00010\u0002H\u0007J\n\u0010/\u001a\u0004\u0018\u00010\u0002H\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u00060"}, d2={"Lorg/rust/ide/fixes/RsQuickFixBase;", "E", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "place", "Lorg/rust/ide/statistics/IntentionPlace;", "getPlace", "()Lorg/rust/ide/statistics/IntentionPlace;", "setPlace", "(Lorg/rust/ide/statistics/IntentionPlace;)V", "getFamilyName", "", "getText", "startInWriteAction", "", "availableInBatchMode", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;)V", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "invokeInsideMacroExpansion", "originalEditor", "originalFile", "expandedElement", "isAvailable", "applyFix", "getElementToMakeWritable", "currentFile", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getStartElement", "getEndElement", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsQuickFixBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsQuickFixBase.kt\norg/rust/ide/fixes/RsQuickFixBase\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,139:1\n310#2,5:140\n*S KotlinDebug\n*F\n+ 1 RsQuickFixBase.kt\norg/rust/ide/fixes/RsQuickFixBase\n*L\n57#1:140,5\n*E\n"})
public abstract class RsQuickFixBase<E extends PsiElement>
extends LocalQuickFixAndIntentionActionOnPsiElement
implements LocalQuickFix {
    @Nullable
    private IntentionPlace place;

    public RsQuickFixBase(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        super(element);
    }

    @Nullable
    public final IntentionPlace getPlace() {
        return this.place;
    }

    public final void setPlace(@Nullable IntentionPlace intentionPlace) {
        this.place = intentionPlace;
    }

    @NotNull
    public abstract String getFamilyName();

    @NotNull
    public abstract String getText();

    public boolean startInWriteAction() {
        return true;
    }

    public boolean availableInBatchMode() {
        return true;
    }

    public abstract void invoke(@NotNull Project var1, @Nullable Editor var2, @NotNull E var3);

    public final void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (RsExpandedElementKt.isExpandedFromMacro(startElement)) {
            this.invokeInsideMacroExpansion(project, editor2, psiFile, startElement);
        } else {
            this.invoke(project, editor2, startElement);
        }
        if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
            boolean $i$f$testAssert = false;
            if (UtilsKt.isUnitTestMode()) {
                boolean bl = false;
                if (!(this.place != null)) {
                    boolean bl2 = false;
                    String message$iv = "Use [setIntentionPlaceForFix]";
                    throw new AssertionError((Object)message$iv);
                }
            }
            IntentionPlace intentionPlace = this.place;
            if (intentionPlace == null) {
                return;
            }
            RsCounterUsagesCollector.INSTANCE.logQuickFixCalled(project, this, intentionPlace);
        }
    }

    private final void invokeInsideMacroExpansion(Project project, Editor originalEditor, PsiFile originalFile, PsiElement expandedElement) {
        IntentionInMacroUtil.INSTANCE.runActionInsideMacroExpansionCopy(project, originalEditor, originalFile, expandedElement, (arg_0, arg_1) -> RsQuickFixBase.invokeInsideMacroExpansion$lambda$0(this, project, arg_0, arg_1));
    }

    public final boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        return super.isAvailable(project, psiFile, startElement, endElement);
    }

    public final void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        super.invoke(project, psiFile, startElement, endElement);
    }

    public final boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        return super.isAvailable(project, psiFile, editor2, startElement, endElement);
    }

    public final void applyFix() {
        super.applyFix();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        if (!this.startInWriteAction()) {
            return null;
        }
        PsiElement element = super.getStartElement();
        Intrinsics.checkNotNull((Object)element);
        RsPossibleMacroCall macroCall = RsExpandedElementKt.findMacroCallExpandedFrom(element);
        PsiFile originalContainingFile = macroCall != null ? macroCall.getContainingFile() : element.getContainingFile();
        return Intrinsics.areEqual((Object)originalContainingFile, (Object)currentFile.getOriginalFile()) ? (PsiElement)currentFile : (PsiElement)originalContainingFile;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        FileModifier fileModifier;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        PsiElement psiElement2 = super.getStartElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getStartElement(...)");
        if (!RsExpandedElementKt.isExpandedFromMacro(psiElement2)) {
            fileModifier = super.getFileModifierForPreview(target);
        } else {
            if (super.getFileModifierForPreview(target) != this) {
                return null;
            }
            fileModifier = (FileModifier)this;
        }
        return fileModifier;
    }

    @NotNull
    public final IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = super.generatePreview(project, previewDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"generatePreview(...)");
        return intentionPreviewInfo;
    }

    @Deprecated(message="In the case of a macro, this method returns a wrong PSI element", replaceWith=@ReplaceWith(expression="element", imports={}))
    @Nullable
    public final PsiElement getStartElement() {
        return super.getStartElement();
    }

    @Deprecated(message="It is always null", replaceWith=@ReplaceWith(expression="null", imports={}))
    @Nullable
    public final PsiElement getEndElement() {
        return null;
    }

    private static final boolean invokeInsideMacroExpansion$lambda$0(RsQuickFixBase this$0, Project $project, Editor editorCopy, PsiElement expandedElementCopy) {
        Intrinsics.checkNotNullParameter((Object)expandedElementCopy, (String)"expandedElementCopy");
        this$0.invoke($project, editorCopy, expandedElementCopy);
        return true;
    }
}

