/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiFileRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsNavigateFixBase;
import org.rust.lang.core.psi.RsFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/fixes/RsNavigateToErrorFix;", "Lorg/rust/ide/fixes/RsNavigateFixBase;", "containingFile", "Lorg/rust/lang/core/psi/RsFile;", "range", "Lcom/intellij/psi/SmartPsiFileRange;", "errorDescription", "", "Lcom/intellij/codeInspection/util/IntentionName;", "<init>", "(Lorg/rust/lang/core/psi/RsFile;Lcom/intellij/psi/SmartPsiFileRange;Ljava/lang/String;)V", "getText", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "collectExplanations", "", "Lorg/rust/ide/fixes/RsNavigateFixBase$ExplanationAction;", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsNavigateToErrorFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsNavigateToErrorFix.kt\norg/rust/ide/fixes/RsNavigateToErrorFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class RsNavigateToErrorFix
extends RsNavigateFixBase {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiFileRange range;
    @NotNull
    private final String errorDescription;

    public RsNavigateToErrorFix(@NotNull RsFile containingFile, @NotNull SmartPsiFileRange range, @NotNull String errorDescription) {
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)errorDescription, (String)"errorDescription");
        super(containingFile, RsBundle.INSTANCE.message("popup.title.navigate.to.error", new Object[0]));
        this.range = range;
        this.errorDescription = errorDescription;
    }

    @Override
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.navigate.to.error", new Object[0]);
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return (IntentionPreviewInfo)new IntentionPreviewInfo.Html(RsBundle.INSTANCE.message("navigates.from.cause.to.error", new Object[0]));
    }

    @Override
    @NotNull
    protected List<RsNavigateFixBase.ExplanationAction> collectExplanations(@NotNull EditorEx editor2, @NotNull RsFile containingFile) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Segment segment = this.range.getRange();
        if (segment == null) {
            return CollectionsKt.emptyList();
        }
        Segment it2 = segment;
        boolean bl = false;
        TextRange range = new TextRange(it2.getStartOffset(), it2.getEndOffset());
        RsNavigateFixBase.ExplanationAction action2 = new RsNavigateFixBase.ExplanationAction(editor2, this.errorDescription, this.errorDescription, (PsiFile)containingFile, range);
        return CollectionsKt.listOf((Object)action2);
    }
}

