/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.intentions.util.macros.IntentionInMacroUtil;
import org.rust.ide.refactoring.ExtraxtExpressionUiKt;
import org.rust.ide.utils.template.EditorExtKt;
import org.rust.ide.utils.template.RsTemplateBuilder;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsLabel;
import org.rust.lang.core.psi.RsLabelDecl;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsLabelReferenceOwner;
import org.rust.lang.core.psi.ext.RsLooplikeExpr;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/fixes/RsAddLabelFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsLabelReferenceOwner;", "element", "<init>", "(Lorg/rust/lang/core/psi/ext/RsLabelReferenceOwner;)V", "getFamilyName", "", "getText", "startInWriteAction", "", "availableInBatchMode", "getElementToMakeWritable", "Lcom/intellij/psi/PsiFile;", "currentFile", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "addLabelDeclaration", "loop", "Lorg/rust/lang/core/psi/ext/RsLooplikeExpr;", "owner", "Companion", "intellij.rustrover.core"})
public final class RsAddLabelFix
extends RsQuickFixBase<RsLabelReferenceOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private RsAddLabelFix(RsLabelReferenceOwner element) {
        super((PsiElement)element);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.add.label", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean availableInBatchMode() {
        return false;
    }

    @NotNull
    public PsiFile getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return currentFile;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsLabelReferenceOwner element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UtilsKt.checkWriteAccessNotAllowed();
        if (editor2 == null) {
            return;
        }
        List loops = RsAddLabelFix.Companion.loops(element, element.getLabel() != null);
        switch (loops.size()) {
            case 0: {
                return;
            }
            case 1: {
                RsAddLabelFix.invoke$runCommand(project, this, editor2, element, (RsLooplikeExpr)CollectionsKt.single((List)loops));
                break;
            }
            default: {
                ExtraxtExpressionUiKt.showExpressionChooser(editor2, loops, (Function1<? super RsExpr, Unit>)((Function1)arg_0 -> RsAddLabelFix.invoke$lambda$1(project, this, editor2, element, arg_0)));
            }
        }
    }

    private final void addLabelDeclaration(Editor editor2, RsLooplikeExpr loop, RsLabelReferenceOwner owner) {
        RsLabel newLabel;
        PsiElement psiElement2;
        RsLabelDecl newLabelDecl;
        PsiElement psiElement3;
        Object labelName;
        Object object;
        Project project = loop.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
        RsLabelDecl labelDecl = loop.getLabelDecl();
        RsLabel label = owner.getLabel();
        Object object2 = labelDecl;
        if (object2 == null || (object2 = object2.getName()) == null) {
            RsLabel rsLabel = label;
            object2 = object = rsLabel != null ? rsLabel.getReferenceName() : null;
        }
        if (object2 == null || (object = StringsKt.removePrefix((String)object, (CharSequence)"'")) == null) {
            object = labelName = "label";
        }
        RsLabelDecl rsLabelDecl = labelDecl == null ? ((psiElement3 = loop.addBefore(factory2.createLabelDeclaration((String)labelName), loop.getFirstChild())) instanceof RsLabelDecl ? (RsLabelDecl)psiElement3 : null) : (newLabelDecl = null);
        RsLabel rsLabel = label == null ? ((psiElement2 = owner.addAfter(factory2.createLabel((String)labelName), owner.getOperator())) instanceof RsLabel ? (RsLabel)psiElement2 : null) : (newLabel = null);
        if (newLabelDecl != null && newLabel != null) {
            RsTemplateBuilder template2 = EditorExtKt.newTemplateBuilder$default(editor2, loop, false, 2, null);
            PsiElement psiElement4 = newLabelDecl.getQuoteIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getQuoteIdentifier(...)");
            RsTemplateBuilder.TemplateVariable variable = RsTemplateBuilder.introduceVariable$default(template2, psiElement4, null, 2, null);
            variable.replaceElementWithVariable(newLabel);
            template2.runInline();
        }
    }

    private static final void invoke$runCommand(Project $project, RsAddLabelFix this$0, Editor $editor, RsLabelReferenceOwner $element, RsLooplikeExpr loop) {
        UtilsKt.runWriteCommandAction($project, this$0.getText(), new PsiFile[0], () -> RsAddLabelFix.invoke$runCommand$lambda$0(this$0, $editor, loop, $element));
    }

    private static final Unit invoke$runCommand$lambda$0(RsAddLabelFix this$0, Editor $editor, RsLooplikeExpr $loop, RsLabelReferenceOwner $element) {
        this$0.addLabelDeclaration($editor, $loop, $element);
        IntentionInMacroUtil.INSTANCE.finishActionInMacroExpansionCopy($editor);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$1(Project $project, RsAddLabelFix this$0, Editor $editor, RsLabelReferenceOwner $element, RsExpr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        RsAddLabelFix.invoke$runCommand($project, this$0, $editor, $element, (RsLooplikeExpr)it2);
        return Unit.INSTANCE;
    }

    public /* synthetic */ RsAddLabelFix(RsLabelReferenceOwner element, DefaultConstructorMarker $constructor_marker) {
        this(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/rust/ide/fixes/RsAddLabelFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/RsAddLabelFix;", "element", "Lorg/rust/lang/core/psi/ext/RsLabelReferenceOwner;", "loops", "", "Lorg/rust/lang/core/psi/ext/RsLooplikeExpr;", "nonLabeledOnly", "", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsAddLabelFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsAddLabelFix.kt\norg/rust/ide/fixes/RsAddLabelFix$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n774#2:85\n865#2,2:86\n*S KotlinDebug\n*F\n+ 1 RsAddLabelFix.kt\norg/rust/ide/fixes/RsAddLabelFix$Companion\n*L\n81#1:85\n81#1:86,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RsAddLabelFix createIfCompatible(@NotNull RsLabelReferenceOwner element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (this.loops(element, element.getLabel() != null).isEmpty()) {
                return null;
            }
            return new RsAddLabelFix(element, null);
        }

        /*
         * WARNING - void declaration
         */
        private final List<RsLooplikeExpr> loops(RsLabelReferenceOwner $this$loops, boolean nonLabeledOnly) {
            void $this$filterTo$iv$iv;
            List list = PsiTreeUtil.collectParents((PsiElement)$this$loops, RsLooplikeExpr.class, (boolean)false, arg_0 -> Companion.loops$lambda$1(Companion::loops$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectParents(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RsLooplikeExpr it2 = (RsLooplikeExpr)element$iv$iv;
                boolean bl = false;
                if (!(!nonLabeledOnly || it2.getLabelDecl() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static final boolean loops$lambda$0(PsiElement it2) {
            return it2 instanceof RsItemElement;
        }

        private static final boolean loops$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

