/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsExprKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/fixes/ReplaceWithStdMemDropFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lcom/intellij/psi/PsiElement;", "call", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "createStdMemDropCall", "Lorg/rust/lang/core/psi/RsCallExpr;", "args", "", "Lorg/rust/lang/core/psi/RsExpr;", "intellij.rustrover.core"})
public final class ReplaceWithStdMemDropFix
extends RsQuickFixBase<PsiElement> {
    public ReplaceWithStdMemDropFix(@NotNull PsiElement call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        super(call2);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.replace.with.std.mem.drop", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        Pair pair;
        List args;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement2 = element;
        if (psiElement2 instanceof RsCallExpr) {
            List list;
            List list2 = ((RsCallExpr)element).getValueArgumentList().getExprList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
            args = list2;
            if (args.size() == 1) {
                RsExpr rsExpr = args.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"get(...)");
                RsExpr self = RsExprKt.unwrapReference(rsExpr);
                list = CollectionsKt.listOf((Object)self);
            } else {
                list = args;
            }
            List dropArgs = list;
            pair = TuplesKt.to((Object)element, dropArgs);
        } else if (psiElement2 instanceof RsMethodCall) {
            RsDotExpr dotExpr = ((RsMethodCall)element).getParent();
            RsExpr expr = dotExpr.getReceiver();
            List<RsExpr> list = ((RsMethodCall)element).getValueArgumentList().getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            List<RsExpr> args2 = list;
            List dropArgs = args2.isEmpty() ? CollectionsKt.listOf((Object)expr) : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)expr), (Iterable)args2);
            pair = TuplesKt.to((Object)dotExpr, (Object)dropArgs);
        } else {
            return;
        }
        Pair pair2 = pair;
        RsExpr old = (RsExpr)pair2.component1();
        args = (List)pair2.component2();
        old.replace(this.createStdMemDropCall(project, args));
    }

    private final RsCallExpr createStdMemDropCall(Project project, Iterable<? extends RsExpr> args) {
        return new RsPsiFactory(project, false, false, 6, null).createFunctionCall("std::mem::drop", args);
    }
}

