/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.utils.import.DocAliasCandidate;
import org.rust.ide.utils.import.ImportUtilsKt;
import org.rust.lang.core.parser.RustParserUtil;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRawIdentifiersKt;
import org.rust.lang.core.psi.ext.RsElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/fixes/ReplaceWithDocAliasedPathFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsElement;", "element", "candidate", "Lorg/rust/ide/utils/import/DocAliasCandidate;", "<init>", "(Lorg/rust/lang/core/psi/ext/RsElement;Lorg/rust/ide/utils/import/DocAliasCandidate;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
public final class ReplaceWithDocAliasedPathFix
extends RsQuickFixBase<RsElement> {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final DocAliasCandidate candidate;

    public ReplaceWithDocAliasedPathFix(@NotNull RsElement element, @NotNull DocAliasCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        super((PsiElement)element);
        this.candidate = candidate;
    }

    @Override
    @NotNull
    public String getText() {
        String string;
        DocAliasCandidate docAliasCandidate = this.candidate;
        if (docAliasCandidate instanceof DocAliasCandidate.Replace) {
            Object[] objectArray = new Object[]{((DocAliasCandidate.Replace)this.candidate).getItemName()};
            string = RsBundle.INSTANCE.message("intention.name.replace.with2", objectArray);
        } else if (docAliasCandidate instanceof DocAliasCandidate.ReplaceQualified) {
            Object[] objectArray = new Object[]{((DocAliasCandidate.ReplaceQualified)this.candidate).getUsePath()};
            string = RsBundle.INSTANCE.message("intention.name.replace.with2", objectArray);
        } else if (docAliasCandidate instanceof DocAliasCandidate.ReplaceAndImport) {
            String path = CollectionsKt.joinToString$default((Iterable)ArraysKt.dropLast((Object[])((DocAliasCandidate.ReplaceAndImport)this.candidate).getImport().getPath(), (int)1), (CharSequence)"::", null, null, (int)0, null, null, (int)62, null);
            Object[] objectArray = new Object[]{((DocAliasCandidate.ReplaceAndImport)this.candidate).getItemName(), path};
            string = RsBundle.INSTANCE.message("intention.name.replace.with.and.import", objectArray);
        } else if (docAliasCandidate instanceof DocAliasCandidate.ReplaceIdentifier) {
            Object[] objectArray = new Object[]{((DocAliasCandidate.ReplaceIdentifier)this.candidate).getItemName()};
            string = RsBundle.INSTANCE.message("intention.name.replace.with2", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
        DocAliasCandidate docAliasCandidate = this.candidate;
        if (docAliasCandidate instanceof DocAliasCandidate.Replace) {
            RsPath rsPath = psiFactory.tryCreatePath(RsRawIdentifiersKt.escapeIdentifierIfNeeded(((DocAliasCandidate.Replace)this.candidate).getItemName()), RustParserUtil.PathParsingMode.VALUE);
            if (rsPath == null) {
                return;
            }
            RsPath item = rsPath;
            v1 = element.replace(item);
        } else if (docAliasCandidate instanceof DocAliasCandidate.ReplaceQualified) {
            RsPath rsPath = psiFactory.tryCreatePath(((DocAliasCandidate.ReplaceQualified)this.candidate).getUsePath(), RustParserUtil.PathParsingMode.VALUE);
            if (rsPath == null) {
                return;
            }
            RsPath item = rsPath;
            v1 = element.replace(item);
        } else if (docAliasCandidate instanceof DocAliasCandidate.ReplaceAndImport) {
            RsPath rsPath = psiFactory.tryCreatePath(RsRawIdentifiersKt.escapeIdentifierIfNeeded(((DocAliasCandidate.ReplaceAndImport)this.candidate).getItemName()), RustParserUtil.PathParsingMode.VALUE);
            if (rsPath == null) {
                return;
            }
            RsPath item = rsPath;
            PsiElement psiElement2 = element.replace(item);
            RsElement rsElement = psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null;
            if (rsElement == null) {
                return;
            }
            RsElement context = rsElement;
            ImportUtilsKt.import(((DocAliasCandidate.ReplaceAndImport)this.candidate).getImport(), context);
            v1 = Unit.INSTANCE;
        } else if (docAliasCandidate instanceof DocAliasCandidate.ReplaceIdentifier) {
            RsPath rsPath = element instanceof RsPath ? (RsPath)element : null;
            if (rsPath == null) {
                return;
            }
            RsPath path = rsPath;
            PsiElement identifier = psiFactory.createIdentifier(RsRawIdentifiersKt.escapeIdentifierIfNeeded(((DocAliasCandidate.ReplaceIdentifier)this.candidate).getItemName()));
            PsiElement psiElement3 = path.getIdentifier();
            v1 = psiElement3 != null ? psiElement3.replace(identifier) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

