/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.utils.import.DocAliasCandidate;
import org.rust.ide.utils.import.ImportUtilsKt;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRawIdentifiersKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMethodOrFieldKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/fixes/ReplaceWithDocAliasMethodFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsMethodCall;", "element", "candidate", "Lorg/rust/ide/utils/import/DocAliasCandidate$MethodAliasCandidate;", "<init>", "(Lorg/rust/lang/core/psi/RsMethodCall;Lorg/rust/ide/utils/import/DocAliasCandidate$MethodAliasCandidate;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
public final class ReplaceWithDocAliasMethodFix
extends RsQuickFixBase<RsMethodCall> {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final DocAliasCandidate.MethodAliasCandidate candidate;

    public ReplaceWithDocAliasMethodFix(@NotNull RsMethodCall element, @NotNull DocAliasCandidate.MethodAliasCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        super((PsiElement)element);
        this.candidate = candidate;
    }

    @Override
    @NotNull
    public String getText() {
        String string;
        DocAliasCandidate.MethodAliasCandidate methodAliasCandidate = this.candidate;
        if (methodAliasCandidate instanceof DocAliasCandidate.Replace) {
            Object[] objectArray = new Object[]{((DocAliasCandidate.Replace)this.candidate).getItemName()};
            string = RsBundle.INSTANCE.message("intention.name.replace.with2", objectArray);
        } else if (methodAliasCandidate instanceof DocAliasCandidate.ReplaceAndImport) {
            String path = ArraysKt.joinToString$default((Object[])((DocAliasCandidate.ReplaceAndImport)this.candidate).getImport().getPath(), (CharSequence)"::", null, null, (int)0, null, null, (int)62, null);
            Object[] objectArray = new Object[]{((DocAliasCandidate.ReplaceAndImport)this.candidate).getItemName(), path};
            string = RsBundle.INSTANCE.message("intention.name.replace.with.and.import", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsMethodCall element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
        DocAliasCandidate.MethodAliasCandidate methodAliasCandidate = this.candidate;
        if (methodAliasCandidate instanceof DocAliasCandidate.Replace) {
            PsiElement identifier = psiFactory.createIdentifier(RsRawIdentifiersKt.escapeIdentifierIfNeeded(((DocAliasCandidate.Replace)this.candidate).getItemName()));
            element.getIdentifier().replace(identifier);
        } else if (methodAliasCandidate instanceof DocAliasCandidate.ReplaceAndImport) {
            RsExpr rsExpr = RsMethodOrFieldKt.getReceiver(element);
            String string = RsRawIdentifiersKt.escapeIdentifierIfNeeded(((DocAliasCandidate.ReplaceAndImport)this.candidate).getItemName());
            List<RsExpr> list = element.getValueArgumentList().getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            RsMethodCallExpr rsMethodCallExpr = psiFactory.tryCreateMethodCall(rsExpr, string, list, element.getTypeArgumentList());
            if (rsMethodCallExpr == null) {
                return;
            }
            RsMethodCallExpr item = rsMethodCallExpr;
            PsiElement psiElement2 = element.getParent().replace(item);
            RsElement rsElement = psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null;
            if (rsElement == null) {
                return;
            }
            RsElement context = rsElement;
            ImportUtilsKt.import(((DocAliasCandidate.ReplaceAndImport)this.candidate).getImport(), context);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

