/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.macros.decl.FragmentKind;
import org.rust.lang.core.psi.RsMacroBinding;
import org.rust.lang.core.psi.RsPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014 \u000b*\t\u0018\u00010\t\u00a2\u0006\u0002\b\n0\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/fixes/ReplaceMacroBindingKind;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsMacroBinding;", "macroBinding", "fragmentKind", "Lorg/rust/lang/core/macros/decl/FragmentKind;", "<init>", "(Lorg/rust/lang/core/psi/RsMacroBinding;Lorg/rust/lang/core/macros/decl/FragmentKind;)V", "identifier", "", "Lcom/intellij/openapi/util/NlsSafe;", "kotlin.jvm.PlatformType", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
public final class ReplaceMacroBindingKind
extends RsQuickFixBase<RsMacroBinding> {
    @NotNull
    private final FragmentKind fragmentKind;
    private final String identifier;

    public ReplaceMacroBindingKind(@NotNull RsMacroBinding macroBinding, @NotNull FragmentKind fragmentKind) {
        Intrinsics.checkNotNullParameter((Object)macroBinding, (String)"macroBinding");
        Intrinsics.checkNotNullParameter((Object)((Object)fragmentKind), (String)"fragmentKind");
        super((PsiElement)macroBinding);
        this.fragmentKind = fragmentKind;
        this.identifier = macroBinding.getMetaVarIdentifier().getText();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{"$" + this.identifier, this.fragmentKind.getKind()};
        return RsBundle.INSTANCE.message("intention.family.name.replace.fragment.specifier", objectArray);
    }

    @Override
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsMacroBinding element) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement newKind = new RsPsiFactory(project, false, false, 6, null).createIdentifier(this.fragmentKind.getKind());
            PsiElement psiElement2 = element.getIdentifier();
            if (psiElement2 == null) break block0;
            psiElement2.replace(newKind);
        }
    }
}

