/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.refactoring.RenameUtilsKt;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsModDeclItem;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.resolve.ref.RsReference;
import org.rust.openapiext.RsPluginDisposable;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/fixes/RenameFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lcom/intellij/psi/PsiNamedElement;", "element", "newName", "", "fixName", "<init>", "(Lcom/intellij/psi/PsiNamedElement;Ljava/lang/String;Ljava/lang/String;)V", "getNewName", "()Ljava/lang/String;", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRenameFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameFix.kt\norg/rust/ide/fixes/RenameFix\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,60:1\n450#2,14:61\n*S KotlinDebug\n*F\n+ 1 RenameFix.kt\norg/rust/ide/fixes/RenameFix\n*L\n41#1:61,14\n*E\n"})
public final class RenameFix
extends RsQuickFixBase<PsiNamedElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String newName;
    @NotNull
    private final String fixName;

    public RenameFix(@NotNull PsiNamedElement element, @NotNull String newName, @IntentionName @NotNull String fixName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)fixName, (String)"fixName");
        super((PsiElement)element);
        this.newName = newName;
        this.fixName = fixName;
    }

    public /* synthetic */ RenameFix(PsiNamedElement psiNamedElement, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Object[] objectArray = new Object[]{string};
            string2 = RsBundle.INSTANCE.message("intention.name.rename.to", objectArray);
        }
        this(psiNamedElement, string, string2);
    }

    @NotNull
    public final String getNewName() {
        return this.newName;
    }

    @Override
    @NotNull
    public String getText() {
        return this.fixName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.rename.element", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiNamedElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (PsiElementKt.isIntentionPreviewElement((PsiElement)element)) {
            element.setName(this.newName);
            return;
        }
        Project $this$nonBlocking$iv = project;
        boolean $i$f$nonBlocking = false;
        if (UtilsKt.isUnitTestMode()) {
            PsiElement result$iv;
            boolean bl = false;
            PsiElement it2 = result$iv = Companion.findElementToRename(element);
            boolean bl2 = false;
            RefactoringFactory.getInstance((Project)project).createRename(it2, this.getNewName()).run();
        } else {
            Function1 function1 = (Function1)new Function1<PsiElement, Unit>(project, this){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ RenameFix this$0;
                {
                    this.$project$inlined = project;
                    this.this$0 = renameFix;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(Object result2) {
                    PsiElement it2 = (PsiElement)result2;
                    boolean bl = false;
                    RefactoringFactory.getInstance((Project)this.$project$inlined).createRename(it2, this.this$0.getNewName()).run();
                }
            };
            CancellablePromise cancellablePromise = ReadAction.nonBlocking((Callable)new Callable(element){
                final /* synthetic */ PsiNamedElement $element$inlined;
                {
                    this.$element$inlined = psiNamedElement;
                }

                public final PsiElement call() {
                    boolean bl = false;
                    return RenameFix.Companion.findElementToRename(this.$element$inlined);
                }
            }).inSmartMode($this$nonBlocking$iv).expireWith(RsPluginDisposable.Companion.getInstance($this$nonBlocking$iv)).finishOnUiThread(ModalityState.current(), new Consumer(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void accept(Object p0) {
                    this.function.invoke(p0);
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
            Intrinsics.checkNotNull((Object)cancellablePromise);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/fixes/RenameFix$Companion;", "", "<init>", "()V", "findElementToRename", "Lcom/intellij/psi/PsiElement;", "element", "Lcom/intellij/psi/PsiNamedElement;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRenameFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameFix.kt\norg/rust/ide/fixes/RenameFix$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PsiElement findElementToRename(@NotNull PsiNamedElement element) {
            RsElement rsElement;
            RsReference rsReference;
            RsModDeclItem rsModDeclItem;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsModDeclItem rsModDeclItem2 = rsModDeclItem = element instanceof RsModDeclItem ? (RsModDeclItem)element : null;
            if (rsModDeclItem != null && (rsReference = rsModDeclItem.getReference()) != null && (rsElement = rsReference.resolve()) != null) {
                RsElement it2 = rsElement;
                boolean bl = false;
                return it2;
            }
            if (RsExpandedElementKt.isExpandedFromMacro((PsiElement)element)) {
                PsiFile psiFile = element.getContainingFile().getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
                PsiFile originalFile = psiFile;
                PsiElement psiElement2 = PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiElement)element), (PsiFile)originalFile);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"findSameElementInCopy(...)");
                return RenameUtilsKt.substituteElementToRename(psiElement2);
            }
            return (PsiElement)element;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

