/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RemoveVariableFixKt;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.ext.RsPatBindingKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/fixes/RemoveVariableFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsPatBinding;", "binding", "bindingName", "", "<init>", "(Lorg/rust/lang/core/psi/RsPatBinding;Ljava/lang/String;)V", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
public final class RemoveVariableFix
extends RsQuickFixBase<RsPatBinding> {
    @NotNull
    private final String bindingName;

    public RemoveVariableFix(@NotNull RsPatBinding binding, @NotNull String bindingName) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)bindingName, (String)"bindingName");
        super((PsiElement)binding);
        this.bindingName = bindingName;
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.bindingName};
        return RsBundle.INSTANCE.message("intention.name.remove.variable", objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.remove.variable", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsPatBinding element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsPat rsPat = RsPatBindingKt.getTopLevelPattern(element);
        RsPatIdent rsPatIdent = rsPat instanceof RsPatIdent ? (RsPatIdent)rsPat : null;
        if (rsPatIdent == null) {
            return;
        }
        RsPatIdent patIdent = rsPatIdent;
        RemoveVariableFixKt.access$deleteVariable(patIdent);
    }
}

