/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.PsiElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u0015\u0010\u0004\u001a\u00070\u000b\u00a2\u0006\u0002\b\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/fixes/RemovePositionalParameterFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsLitExpr;", "formatStr", "lastPositionalArgumentRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lorg/rust/lang/core/psi/RsLitExpr;Lcom/intellij/openapi/util/TextRange;)V", "getFamilyName", "", "getText", "Lcom/intellij/psi/SmartPsiFileRange;", "Lorg/jetbrains/annotations/NotNull;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
public final class RemovePositionalParameterFix
extends RsQuickFixBase<RsLitExpr> {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiFileRange lastPositionalArgumentRange;

    public RemovePositionalParameterFix(@NotNull RsLitExpr formatStr, @NotNull TextRange lastPositionalArgumentRange) {
        Intrinsics.checkNotNullParameter((Object)formatStr, (String)"formatStr");
        Intrinsics.checkNotNullParameter((Object)lastPositionalArgumentRange, (String)"lastPositionalArgumentRange");
        super((PsiElement)formatStr);
        SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)formatStr.getProject()).createSmartPsiFileRangePointer(formatStr.getContainingFile(), lastPositionalArgumentRange);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        this.lastPositionalArgumentRange = smartPsiFileRange;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.remove.format.parameter", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsLitExpr element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Segment segment = this.lastPositionalArgumentRange.getRange();
        if (segment == null) {
            return;
        }
        Segment argRange = segment;
        RsLiteralKind rsLiteralKind = RsLiteralKindKt.getKind(element);
        Object object = rsLiteralKind instanceof RsLiteralKind.String ? (RsLiteralKind.String)rsLiteralKind : null;
        if (object == null || (object = ((RsLiteralKind.String)object).getRawValue()) == null) {
            return;
        }
        Object formatStrValue = object;
        int formatStrStart = PsiElementKt.getStartOffset(element) + 1;
        int argStartInStr = argRange.getStartOffset() - formatStrStart;
        int argEndInStr = argRange.getEndOffset() - formatStrStart;
        RemovePositionalParameterFix $this$invoke_u24lambda_u240 = this;
        boolean bl = false;
        int lastChecked = argStartInStr;
        while (lastChecked - 1 >= 0 && CharsKt.isWhitespace((char)((String)formatStrValue).charAt(lastChecked - 1))) {
            --lastChecked;
        }
        int leftWhiteSpacesStart = lastChecked;
        RsLitExpr lit = new RsPsiFactory(project, false, false, 6, null).createLitExpr(((Object)StringsKt.removeRange((CharSequence)((CharSequence)formatStrValue), (int)leftWhiteSpacesStart, (int)argEndInStr)).toString());
        element.replace(lit);
    }
}

