/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RemoveParameterFixKt;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.completion.UtilsKt;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsPatBindingKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/fixes/RemoveParameterFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsPatBinding;", "binding", "bindingName", "", "<init>", "(Lorg/rust/lang/core/psi/RsPatBinding;Ljava/lang/String;)V", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRemoveParameterFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveParameterFix.kt\norg/rust/ide/fixes/RemoveParameterFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,62:1\n66#2,2:63\n*S KotlinDebug\n*F\n+ 1 RemoveParameterFix.kt\norg/rust/ide/fixes/RemoveParameterFix\n*L\n31#1:63,2\n*E\n"})
public final class RemoveParameterFix
extends RsQuickFixBase<RsPatBinding> {
    @NotNull
    private final String bindingName;

    public RemoveParameterFix(@NotNull RsPatBinding binding, @NotNull String bindingName) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)bindingName, (String)"bindingName");
        super((PsiElement)binding);
        this.bindingName = bindingName;
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.bindingName};
        return RsBundle.INSTANCE.message("intention.name.remove.parameter", objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.remove.parameter", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsPatBinding element) {
        int parameterIndex;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsPat rsPat = RsPatBindingKt.getTopLevelPattern(element);
        RsPatIdent rsPatIdent = rsPat instanceof RsPatIdent ? (RsPatIdent)rsPat : null;
        if (rsPatIdent == null) {
            return;
        }
        RsPatIdent patIdent = rsPatIdent;
        PsiElement psiElement2 = patIdent.getParent();
        RsValueParameter rsValueParameter = psiElement2 instanceof RsValueParameter ? (RsValueParameter)psiElement2 : null;
        if (rsValueParameter == null) {
            return;
        }
        RsValueParameter parameter = rsValueParameter;
        PsiElement $this$parentOfType_u24default$iv = parameter;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        RsFunction rsFunction = (RsFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsFunction.class, (boolean)true);
        if (rsFunction == null) {
            return;
        }
        RsFunction function = rsFunction;
        RsFunction originalFunction = (RsFunction)UtilsKt.safeGetOriginalOrSelf((PsiElement)function);
        List calls = PsiElementKt.isIntentionPreviewElement(function) ? CollectionsKt.emptyList() : SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)RsFunctionKt.findFunctionCalls$default(originalFunction, null, 1, null), (Sequence)RsFunctionKt.findMethodCalls$default(originalFunction, null, 1, null)));
        Object object = function.getValueParameterList();
        int n = object != null && (object = object.getValueParameterList()) != null ? object.indexOf(parameter) : (parameterIndex = -1);
        if (parameterIndex == -1) {
            return;
        }
        RsElementKt.deleteWithSurroundingCommaAndWhitespace(parameter);
        RemoveParameterFixKt.access$removeArguments(function, calls, parameterIndex);
    }
}

