/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.RsWrongGenericArgumentsNumberInspectionKt;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsTypeArgumentList;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsMethodOrPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\f\u0010\u0012\u001a\u00020\r*\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/fixes/RemoveGenericArguments;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsMethodOrPath;", "element", "startIndex", "", "endIndex", "<init>", "(Lorg/rust/lang/core/psi/ext/RsMethodOrPath;II)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "removeTypeParameters", "Lorg/rust/lang/core/psi/RsTypeArgumentList;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRemoveGenericArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveGenericArguments.kt\norg/rust/ide/fixes/RemoveGenericArguments\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1056#2:43\n1869#2,2:44\n*S KotlinDebug\n*F\n+ 1 RemoveGenericArguments.kt\norg/rust/ide/fixes/RemoveGenericArguments\n*L\n33#1:43\n35#1:44,2\n*E\n"})
public final class RemoveGenericArguments
extends RsQuickFixBase<RsMethodOrPath> {
    private final int startIndex;
    private final int endIndex;

    public RemoveGenericArguments(@NotNull RsMethodOrPath element, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.remove.redundant.generic.arguments", new Object[0]);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsMethodOrPath element) {
        block1: {
            RsTypeArgumentList typeArguments;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Pair<RsTypeArgumentList, RsGenericDeclaration> pair = RsWrongGenericArgumentsNumberInspectionKt.getTypeArgumentsAndDeclaration(element);
            if (pair == null) {
                return;
            }
            RsTypeArgumentList rsTypeArgumentList = typeArguments = (RsTypeArgumentList)pair.component1();
            if (rsTypeArgumentList == null) break block1;
            this.removeTypeParameters(rsTypeArgumentList);
        }
    }

    private final void removeTypeParameters(RsTypeArgumentList $this$removeTypeParameters) {
        List<RsTypeReference> list = $this$removeTypeParameters.getTypeReferenceList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeReferenceList(...)");
        Collection collection = list;
        List<RsExpr> list2 = $this$removeTypeParameters.getExprList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PsiElement it2 = (PsiElement)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(PsiElementKt.getStartOffset(it2));
                it2 = (PsiElement)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(PsiElementKt.getStartOffset(it2)));
            }
        }).subList(this.startIndex, this.endIndex);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it2 = (PsiElement)element$iv;
            boolean bl = false;
            RsElementKt.deleteWithSurroundingComma((RsElement)it2);
        }
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getNextNonCommentSibling($this$removeTypeParameters.getLt()), (Object)$this$removeTypeParameters.getGt())) {
            $this$removeTypeParameters.delete();
        }
    }
}

