/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.utils.import.ImportInfo;
import org.rust.ide.utils.import.ImportUtilsKt;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTypeArgumentList;
import org.rust.lang.core.psi.ext.PsiElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/fixes/QualifyPathFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsPath;", "path", "importInfo", "Lorg/rust/ide/utils/import/ImportInfo;", "<init>", "(Lorg/rust/lang/core/psi/RsPath;Lorg/rust/ide/utils/import/ImportInfo;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Companion", "intellij.rustrover.core"})
public final class QualifyPathFix
extends RsQuickFixBase<RsPath> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final ImportInfo importInfo;

    public QualifyPathFix(@NotNull RsPath path, @NotNull ImportInfo importInfo) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)importInfo, (String)"importInfo");
        super((PsiElement)path);
        this.importInfo = importInfo;
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.importInfo.getUsePath()};
        return RsBundle.INSTANCE.message("intention.name.qualify.path.to", objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.qualify.path", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsPath element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Companion.qualify(element, this.importInfo);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/rust/ide/fixes/QualifyPathFix$Companion;", "", "<init>", "()V", "qualify", "Lcom/intellij/psi/PsiElement;", "path", "Lorg/rust/lang/core/psi/RsPath;", "importInfo", "Lorg/rust/ide/utils/import/ImportInfo;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiElement qualify(@NotNull RsPath path, @NotNull ImportInfo importInfo) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)importInfo, (String)"importInfo");
            String qualifiedPath = importInfo.getUsePath();
            RsTypeArgumentList rsTypeArgumentList = path.getTypeArgumentList();
            String string = rsTypeArgumentList != null ? rsTypeArgumentList.getText() : null;
            if (string == null) {
                string = "";
            }
            String fullPath = qualifiedPath + string;
            Project project = path.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsPath rsPath = RsPsiFactory.tryCreatePath$default(new RsPsiFactory(project, false, false, 6, null), fullPath, null, 2, null);
            if (rsPath == null) {
                return null;
            }
            RsPath newPath = rsPath;
            if (!PsiElementKt.isIntentionPreviewElement(path)) {
                ImportUtilsKt.insertExternCrateIfNeeded(importInfo, path);
            }
            return path.replace(newPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

