/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.refactoring.RsImportOptimizer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/fixes/OptimiseImportsFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "", "intellij.rustrover.core"})
public final class OptimiseImportsFix
extends RsQuickFixBase<PsiElement>
implements HighPriorityAction {
    public OptimiseImportsFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("optimize.imports.fix", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("optimize.imports.fix", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile file = element.getContainingFile();
        ImportOptimizer optimizer = new RsImportOptimizer();
        Runnable runnable = optimizer.processFile(file);
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"processFile(...)");
        Runnable runnable2 = runnable;
        PsiFile[] psiFileArray = new PsiFile[]{file};
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])psiFileArray).withName(this.getFamilyName()).run(() -> OptimiseImportsFix.invoke$lambda$0(runnable2));
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static final void invoke$lambda$0(Runnable $runnable) {
        $runnable.run();
    }
}

