/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.intentions.visibility.ChangeVisibilityIntention;
import org.rust.lang.core.psi.ext.RsVisibilityOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B#\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/fixes/MakePublicFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsVisibilityOwner;", "element", "elementName", "", "withinOneCrate", "", "<init>", "(Lorg/rust/lang/core/psi/ext/RsVisibilityOwner;Ljava/lang/String;Z)V", "_text", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.rustrover.core"})
public final class MakePublicFix
extends RsQuickFixBase<RsVisibilityOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean withinOneCrate;
    @IntentionName
    @NotNull
    private final String _text;

    private MakePublicFix(RsVisibilityOwner element, String elementName, boolean withinOneCrate) {
        super((PsiElement)element);
        this.withinOneCrate = withinOneCrate;
        Object[] objectArray = new Object[1];
        String string = elementName;
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        this._text = RsBundle.INSTANCE.message("intention.name.make.public", objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.make.public", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return this._text;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsVisibilityOwner element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ChangeVisibilityIntention.Companion.makePublic(element, this.withinOneCrate);
    }

    public /* synthetic */ MakePublicFix(RsVisibilityOwner element, String elementName, boolean withinOneCrate, DefaultConstructorMarker $constructor_marker) {
        this(element, elementName, withinOneCrate);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/ide/fixes/MakePublicFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/MakePublicFix;", "visible", "Lorg/rust/lang/core/psi/ext/RsVisibilityOwner;", "elementName", "", "crateRestricted", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MakePublicFix createIfCompatible(@NotNull RsVisibilityOwner visible, @Nullable String elementName, boolean crateRestricted) {
            Intrinsics.checkNotNullParameter((Object)visible, (String)"visible");
            if (!ChangeVisibilityIntention.Companion.isValidVisibilityOwner(visible)) {
                return null;
            }
            return new MakePublicFix(visible, elementName, crateRestricted, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

