/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.intentions.visibility.ChangeVisibilityIntention;
import org.rust.lang.core.psi.ext.RsVisibilityOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/fixes/MakePrivateFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsVisibilityOwner;", "element", "<init>", "(Lorg/rust/lang/core/psi/ext/RsVisibilityOwner;)V", "elementName", "", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
public final class MakePrivateFix
extends RsQuickFixBase<RsVisibilityOwner> {
    @Nullable
    private final String elementName;

    public MakePrivateFix(@NotNull RsVisibilityOwner element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        PsiNamedElement psiNamedElement = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
        this.elementName = psiNamedElement != null ? psiNamedElement.getName() : null;
    }

    @Override
    @NotNull
    public String getText() {
        String string;
        if (this.elementName != null) {
            Object[] objectArray = new Object[]{this.elementName};
            string = RsBundle.INSTANCE.message("intention.name.make.private", objectArray);
        } else {
            string = this.getFamilyName();
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.make.private", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsVisibilityOwner element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ChangeVisibilityIntention.Companion.makePrivate(element);
    }
}

