/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsExternAbi;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.RsFunctionOrLambda;
import org.rust.lang.core.psi.ext.RsFunctionOrLambdaKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/fixes/MakeAsyncFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsFunctionOrLambda;", "function", "<init>", "(Lorg/rust/lang/core/psi/ext/RsFunctionOrLambda;)V", "isFunction", "", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
public final class MakeAsyncFix
extends RsQuickFixBase<RsFunctionOrLambda> {
    private final boolean isFunction;

    public MakeAsyncFix(@NotNull RsFunctionOrLambda function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super((PsiElement)function);
        this.isFunction = function instanceof RsFunction;
    }

    @Override
    @NotNull
    public String getText() {
        String item = this.isFunction ? RsBundle.INSTANCE.message("intention.name.function", new Object[0]) : RsBundle.INSTANCE.message("intention.name.lambda", new Object[0]);
        Object[] objectArray = new Object[]{item};
        return RsBundle.INSTANCE.message("intention.name.make.async", objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.make.async", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsFunctionOrLambda element) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (RsFunctionOrLambdaKt.isAsync(element)) {
            return;
        }
        RsFunctionOrLambda rsFunctionOrLambda = element;
        if (rsFunctionOrLambda instanceof RsFunction) {
            psiElement2 = ((RsFunction)element).getUnsafe();
            if (psiElement2 == null) {
                RsExternAbi rsExternAbi = ((RsFunction)element).getExternAbi();
                if (rsExternAbi != null) {
                    psiElement2 = rsExternAbi;
                } else {
                    PsiElement psiElement3 = ((RsFunction)element).getFn();
                    psiElement2 = psiElement3;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFn(...)");
                }
            }
        } else if (rsFunctionOrLambda instanceof RsLambdaExpr) {
            psiElement2 = ((RsLambdaExpr)element).getMove();
            if (psiElement2 == null) {
                RsValueParameterList rsValueParameterList = ((RsLambdaExpr)element).getValueParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)rsValueParameterList, (String)"<get-valueParameterList>(...)");
                psiElement2 = rsValueParameterList;
            }
        } else {
            throw new IllegalStateException("unreachable".toString());
        }
        PsiElement anchor = psiElement2;
        element.addBefore(new RsPsiFactory(project, false, false, 6, null).createAsyncKeyword(), anchor);
    }
}

