/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.ImportItemFromCrateFixKt;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsAttr;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.stdext.RsResult;
import org.rust.stdext.RsResultKt;
import org.rust.toml.CrateExtKt;
import org.rust.toml.UtilKt;
import org.rust.toml.psi.CargoFile;
import org.rust.toml.psi.CargoFileKt;
import org.rust.util.RsPopularItemsStore;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B/\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/rust/ide/fixes/ImportItemFromCrateFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsElement;", "element", "Lorg/rust/lang/core/psi/ext/RsReferenceElement;", "containingCrate", "Lorg/rust/lang/core/crate/Crate;", "cargoToml", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/toml/lang/psi/TomlFile;", "crateImport", "Lorg/rust/util/RsPopularItemsStore$CrateImport;", "<init>", "(Lorg/rust/lang/core/psi/ext/RsReferenceElement;Lorg/rust/lang/core/crate/Crate;Lcom/intellij/psi/SmartPsiElementPointer;Lorg/rust/util/RsPopularItemsStore$CrateImport;)V", "crate", "", "itemName", "getFamilyName", "getText", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "currentFile", "Lcom/intellij/psi/PsiFile;", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nImportItemFromCrateFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportItemFromCrateFix.kt\norg/rust/ide/fixes/ImportItemFromCrateFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class ImportItemFromCrateFix
extends RsQuickFixBase<RsElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Crate containingCrate;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiElementPointer<TomlFile> cargoToml;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final RsPopularItemsStore.CrateImport crateImport;
    @NotNull
    private final String crate;
    @NotNull
    private final String itemName;

    private ImportItemFromCrateFix(RsReferenceElement element, Crate containingCrate, SmartPsiElementPointer<TomlFile> cargoToml, RsPopularItemsStore.CrateImport crateImport) {
        super((PsiElement)element);
        this.containingCrate = containingCrate;
        this.cargoToml = cargoToml;
        this.crateImport = crateImport;
        this.crate = this.crateImport.getCrateName();
        String string = element.getReferenceName();
        if (string == null) {
            string = "";
        }
        this.itemName = string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.import.item.from.crate", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.itemName, this.crate};
        return RsBundle.INSTANCE.message("intention.name.import.item.from.crate", objectArray);
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return this.cargoToml.getElement();
    }

    @Override
    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        FileModifier fileModifier;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof TomlFile) {
            PsiElement psiElement2 = this.getStartElement();
            RsReferenceElement rsReferenceElement = psiElement2 instanceof RsReferenceElement ? (RsReferenceElement)psiElement2 : null;
            if (rsReferenceElement == null) {
                return null;
            }
            RsReferenceElement element = rsReferenceElement;
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)target));
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
            fileModifier = (FileModifier)new ImportItemFromCrateFix(element, this.containingCrate, (SmartPsiElementPointer<TomlFile>)smartPsiElementPointer, this.crateImport);
        } else {
            fileModifier = null;
        }
        return fileModifier;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsElement element) {
        block5: {
            TomlFile cargoToml;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                TomlFile tomlFile = (TomlFile)this.cargoToml.getElement();
                if (tomlFile == null) {
                    return;
                }
                cargoToml = tomlFile;
                if (PsiElementKt.isIntentionPreviewElement((PsiElement)cargoToml)) break block4;
                if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
                    return;
                }
                String string = this.crateImport.getFullItemPath();
                if (string == null) {
                    string = this.itemName;
                }
                RsResult result2 = ImportItemFromCrateFixKt.importFromCrate$default(element, this.containingCrate, this.crate, string, this.crateImport.getFeatures(), null, 32, null);
                Editor editor3 = editor2;
                if (editor3 == null) break block5;
                Editor it2 = editor3;
                boolean bl = false;
                RsResultKt.showHintOnError(result2, it2);
                break block5;
            }
            CargoFile cargoFile = CargoFileKt.toCargoFile(cargoToml, this.containingCrate);
            if (cargoFile == null) break block5;
            CargoFile it3 = cargoFile;
            boolean bl = false;
            String string = this.crateImport.getFullItemPath();
            if (string == null) {
                string = this.itemName;
            }
            ImportItemFromCrateFixKt.importFromCrate(element, this.containingCrate, this.crate, string, this.crateImport.getFeatures(), it3);
        }
    }

    public /* synthetic */ ImportItemFromCrateFix(RsReferenceElement element, Crate containingCrate, SmartPsiElementPointer cargoToml, RsPopularItemsStore.CrateImport crateImport, DefaultConstructorMarker $constructor_marker) {
        this(element, containingCrate, (SmartPsiElementPointer<TomlFile>)cargoToml, crateImport);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/fixes/ImportItemFromCrateFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/ImportItemFromCrateFix;", "path", "Lorg/rust/lang/core/psi/ext/RsReferenceElement;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nImportItemFromCrateFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportItemFromCrateFix.kt\norg/rust/ide/fixes/ImportItemFromCrateFix$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,155:1\n364#2,2:156\n*S KotlinDebug\n*F\n+ 1 ImportItemFromCrateFix.kt\norg/rust/ide/fixes/ImportItemFromCrateFix$Companion\n*L\n98#1:156,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ImportItemFromCrateFix createIfCompatible(@NotNull RsReferenceElement path) {
            boolean isAttribute;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object object = RsPopularItemsStore.INSTANCE.getItem(path);
            if (object == null || (object = ((RsPopularItemsStore.Item)object).getImport()) == null) {
                return null;
            }
            Object crateImport = object;
            Crate containingCrate = RsElementKt.getContainingCrate(path);
            TomlFile tomlFile = CrateExtKt.getTomlFile(containingCrate);
            if (tomlFile == null) {
                return null;
            }
            TomlFile tomlFile2 = tomlFile;
            if (UtilKt.findDependencyElement(tomlFile2, ((RsPopularItemsStore.CrateImport)crateImport).getCrateName()) != null) {
                return null;
            }
            PsiElement $this$contextOfType_u24default$iv = path;
            boolean withSelf$iv = false;
            boolean $i$f$contextOfType = false;
            boolean bl = isAttribute = PsiTreeUtil.getContextOfType((PsiElement)$this$contextOfType_u24default$iv, RsAttr.class, (boolean)true) != null;
            if (isAttribute == ((RsPopularItemsStore.CrateImport)crateImport).isAttribute()) {
                TomlFile tomlFile3 = CrateExtKt.getTomlFile(containingCrate);
                if (tomlFile3 == null) {
                    return null;
                }
                TomlFile cargoToml = tomlFile3;
                SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)cargoToml));
                Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
                SmartPsiElementPointer tomlFilePointer = smartPsiElementPointer;
                return new ImportItemFromCrateFix(path, containingCrate, tomlFilePointer, (RsPopularItemsStore.CrateImport)crateImport, null);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

