/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.ide.refactoring.implementMembers.ImplKt;
import org.rust.ide.utils.PsiInsertionPlace;
import org.rust.ide.utils.import.RsImportHelper;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsImplItemKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/rust/ide/fixes/ImplementOperatorTraitFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsBinaryExpr;", "expr", "trait", "Lorg/rust/lang/core/psi/RsTraitItem;", "lhsType", "Lorg/rust/lang/core/types/ty/Ty;", "rhsType", "<init>", "(Lorg/rust/lang/core/psi/RsBinaryExpr;Lorg/rust/lang/core/psi/RsTraitItem;Lorg/rust/lang/core/types/ty/Ty;Lorg/rust/lang/core/types/ty/Ty;)V", "traitPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "traitName", "", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "getTopmostParentInsideMod", "Lcom/intellij/psi/PsiElement;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.rustrover.core"})
public final class ImplementOperatorTraitFix
extends RsQuickFixBase<RsBinaryExpr> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ty lhsType;
    @NotNull
    private final Ty rhsType;
    @NotNull
    private final SmartPsiElementPointer<RsTraitItem> traitPointer;
    @NotNull
    private final String traitName;

    public ImplementOperatorTraitFix(@NotNull RsBinaryExpr expr, @NotNull RsTraitItem trait, @NotNull Ty lhsType, @NotNull Ty rhsType) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)trait, (String)"trait");
        Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
        Intrinsics.checkNotNullParameter((Object)rhsType, (String)"rhsType");
        super((PsiElement)expr);
        this.lhsType = lhsType;
        this.rhsType = rhsType;
        this.traitPointer = UtilsKt.createSmartPointer((PsiElement)trait);
        String string = trait.getName();
        if (string == null) {
            string = "<unknown>";
        }
        this.traitName = string;
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.traitName};
        return RsBundle.INSTANCE.message("intention.name.implement.trait2", objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.name.implement.operator.trait", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsBinaryExpr element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement2 = this.getTopmostParentInsideMod(element);
        RsElement rsElement = psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null;
        if (rsElement == null) {
            return;
        }
        RsElement containingItem = rsElement;
        PsiElement psiElement3 = containingItem.getContext();
        RsMod rsMod = psiElement3 instanceof RsMod ? (RsMod)psiElement3 : null;
        if (rsMod == null) {
            return;
        }
        RsMod containingMod = rsMod;
        PsiInsertionPlace psiInsertionPlace = PsiInsertionPlace.Companion.forItemInModBefore(containingMod, containingItem);
        if (psiInsertionPlace == null) {
            return;
        }
        PsiInsertionPlace place = psiInsertionPlace;
        RsTraitItem rsTraitItem = (RsTraitItem)this.traitPointer.getElement();
        if (rsTraitItem == null) {
            return;
        }
        RsImportHelper.INSTANCE.importElement(element, rsTraitItem);
        String lhsTypeText = TypeRenderingKt.renderInsertionSafe$default(this.lhsType, element, 0, null, false, false, false, false, 126, null);
        if (!Intrinsics.areEqual((Object)this.lhsType, (Object)this.rhsType)) {
            String rhsTypeText = TypeRenderingKt.renderInsertionSafe$default(this.rhsType, element, 0, null, false, false, false, false, 126, null);
            object = "<" + rhsTypeText + ">";
        } else {
            object = "";
        }
        String typeArguments = object;
        RsImplItem traitImpl = RsPsiFactory.createTraitImplItem$default(new RsPsiFactory(project, false, false, 6, null), lhsTypeText, this.traitName + typeArguments, null, null, 12, null);
        traitImpl = (RsImplItem)place.insert((PsiElement)traitImpl);
        RsTraitRef rsTraitRef = traitImpl.getTraitRef();
        if (rsTraitRef == null) {
            return;
        }
        RsTraitRef traitRef = rsTraitRef;
        ImplKt.generateMissingTraitMembers(traitImpl, traitRef, editor2);
    }

    private final PsiElement getTopmostParentInsideMod(PsiElement $this$getTopmostParentInsideMod) {
        PsiElement current = $this$getTopmostParentInsideMod;
        while (current.getContext() != null) {
            PsiElement next;
            if (next instanceof RsMod) {
                return current;
            }
            current = next;
        }
        return null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/fixes/ImplementOperatorTraitFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/ImplementOperatorTraitFix;", "expr", "Lorg/rust/lang/core/psi/RsBinaryExpr;", "trait", "Lorg/rust/lang/core/psi/RsTraitItem;", "lhsType", "Lorg/rust/lang/core/types/ty/Ty;", "rhsType", "crate", "Lorg/rust/lang/core/crate/Crate;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ImplementOperatorTraitFix createIfCompatible(@NotNull RsBinaryExpr expr, @NotNull RsTraitItem trait, @NotNull Ty lhsType, @NotNull Ty rhsType, @NotNull Crate crate) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            Intrinsics.checkNotNullParameter((Object)trait, (String)"trait");
            Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
            Intrinsics.checkNotNullParameter((Object)rhsType, (String)"rhsType");
            Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
            Object[] objectArray = new Ty[]{lhsType, rhsType};
            if (!RsImplItemKt.checkOrphanRules(SetsKt.setOf((Object[])objectArray), (Function1<? super RsElement, Boolean>)((Function1)arg_0 -> Companion.createIfCompatible$lambda$0(crate, arg_0)))) {
                return null;
            }
            if (FoldKt.getNeedsSubst(lhsType) || FoldKt.getNeedsSubst(rhsType)) {
                return null;
            }
            return new ImplementOperatorTraitFix(expr, trait, lhsType, rhsType);
        }

        private static final boolean createIfCompatible$lambda$0(Crate $crate, RsElement it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return Intrinsics.areEqual((Object)RsElementKt.getContainingCrate(it2), (Object)$crate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

