/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.refactoring.implementMembers.ImplKt;
import org.rust.ide.utils.PsiInsertionPlace;
import org.rust.ide.utils.import.RsImportHelper;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.resolve.KnownItems;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.core.resolve.NamespaceKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/fixes/ImplementDisplayFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;", "adt", "<init>", "(Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;)V", "_text", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "psiFile", "intellij.rustrover.core"})
public final class ImplementDisplayFix
extends RsQuickFixBase<RsStructOrEnumItemElement> {
    @Nls
    @NotNull
    private final String _text;

    public ImplementDisplayFix(@NotNull RsStructOrEnumItemElement adt) {
        Intrinsics.checkNotNullParameter((Object)adt, (String)"adt");
        super((PsiElement)adt);
        Object[] objectArray = new Object[1];
        if (adt.getName() == null) {
            Object cfr_ignored_0 = objectArray[0];
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this._text = RsBundle.INSTANCE.message("intention.name.implement.display.trait.for", objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this._text;
    }

    @Override
    @NotNull
    public String getText() {
        return this._text;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsStructOrEnumItemElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KnownItems knownItems = KnownItemsKt.getKnownItems(element);
        RsTraitItem rsTraitItem = knownItems.getDisplay();
        if (rsTraitItem == null) {
            return;
        }
        RsTraitItem display = rsTraitItem;
        PsiElement psiElement2 = RsElementKt.findInScope(element, "Display", NamespaceKt.getTYPES());
        if (Intrinsics.areEqual((Object)psiElement2, (Object)display)) {
            string = "Display";
        } else if (psiElement2 == null) {
            RsImportHelper.INSTANCE.importElement(element, display);
            string = "Display";
        } else {
            string = "std::fmt::Display";
        }
        String displayName = string;
        PsiInsertionPlace psiInsertionPlace = PsiInsertionPlace.Companion.forItemInTheScopeOf(element);
        if (psiInsertionPlace == null) {
            return;
        }
        PsiInsertionPlace placeForImpl = psiInsertionPlace;
        RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
        String string2 = element.getName();
        if (string2 == null) {
            return;
        }
        RsImplItem createdImpl = psiFactory.createTraitImplItem(string2, displayName, element.getTypeParameterList(), element.getWhereClause());
        RsImplItem insertedImpl = (RsImplItem)placeForImpl.insert((PsiElement)createdImpl);
        RsTraitRef rsTraitRef = insertedImpl.getTraitRef();
        if (rsTraitRef == null) {
            return;
        }
        ImplKt.generateMissingTraitMembers(insertedImpl, rsTraitRef, editor2);
    }

    @Override
    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

