/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageFeature;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/fixes/EnableCargoFeaturesFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "features", "", "Lorg/rust/cargo/project/workspace/PackageFeature;", "<init>", "(Lorg/rust/cargo/project/model/CargoProject;Ljava/util/Set;)V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.rustrover.core"})
public final class EnableCargoFeaturesFix
implements LocalQuickFix {
    @NotNull
    private final CargoProject cargoProject;
    @NotNull
    private final Set<PackageFeature> features;

    public EnableCargoFeaturesFix(@NotNull CargoProject cargoProject, @NotNull Set<PackageFeature> features) {
        Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        this.cargoProject = cargoProject;
        this.features = features;
    }

    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.enable.features", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CargoProjectServiceKt.getCargoProjects(project).modifyFeatures(this.cargoProject, this.features, FeatureState.Enabled);
    }
}

