/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/fixes/DeriveTraitsFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;", "item", "traits", "", "<init>", "(Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;Ljava/lang/String;)V", "itemName", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Companion", "intellij.rustrover.core"})
public final class DeriveTraitsFix
extends RsQuickFixBase<RsStructOrEnumItemElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String traits;
    @Nullable
    private final String itemName;

    public DeriveTraitsFix(@NotNull RsStructOrEnumItemElement item, @NotNull String traits) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)traits, (String)"traits");
        super((PsiElement)item);
        this.traits = traits;
        this.itemName = item.getName();
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.traits;
        String string = this.itemName;
        if (string == null) {
            string = "";
        }
        objectArray[1] = string;
        return RsBundle.INSTANCE.message("intention.name.add.derive.to", objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.derive.trait", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsStructOrEnumItemElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Companion.invoke(element, this.traits);
        if (!PsiElementKt.isIntentionPreviewElement(element)) {
            RsCounterUsagesCollector.INSTANCE.logDeriveTraitFixCalled(project, this.traits);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/fixes/DeriveTraitsFix$Companion;", "", "<init>", "()V", "invoke", "", "item", "Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;", "traits", "", "updateDeriveAttr", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "deriveAttr", "Lorg/rust/lang/core/psi/RsOuterAttr;", "createDeriveAttr", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void invoke(@NotNull RsStructOrEnumItemElement item, @NotNull String traits) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)traits, (String)"traits");
            Project project = item.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
            RsOuterAttr existingDeriveAttr = RsDocAndAttributeOwnerKt.findOuterAttr(item, "derive");
            if (existingDeriveAttr != null) {
                this.updateDeriveAttr(factory2, existingDeriveAttr, traits);
            } else {
                this.createDeriveAttr(factory2, item, traits);
            }
        }

        private final void updateDeriveAttr(RsPsiFactory psiFactory, RsOuterAttr deriveAttr, String traits) {
            String oldAttrText = deriveAttr.getMetaItem().getText();
            Intrinsics.checkNotNull((Object)oldAttrText);
            String newAttrText = StringsKt.substringBeforeLast$default((String)oldAttrText, (String)")", null, (int)2, null) + ", " + traits + ")";
            RsMetaItem newDeriveAttr = psiFactory.createMetaItem(newAttrText);
            deriveAttr.getMetaItem().replace(newDeriveAttr);
        }

        private final void createDeriveAttr(RsPsiFactory psiFactory, RsStructOrEnumItemElement item, String traits) {
            PsiElement psiElement2 = RsStructOrEnumItemElementKt.getFirstKeyword(item);
            Intrinsics.checkNotNull((Object)psiElement2);
            PsiElement keyword = psiElement2;
            String newAttrText = "derive(" + traits + ")";
            RsOuterAttr newDeriveAttr = psiFactory.createOuterAttr(newAttrText);
            item.addBefore(newDeriveAttr, keyword);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

