/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.annotator.format.FormatParameter;
import org.rust.ide.annotator.format.ImplKt;
import org.rust.ide.fixes.DeriveTraitsFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/fixes/DeriveDebugAndChangeFormatToDebugFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsExpr;", "expr", "parameter", "Lorg/rust/ide/annotator/format/FormatParameter$Value;", "<init>", "(Lorg/rust/lang/core/psi/RsExpr;Lorg/rust/ide/annotator/format/FormatParameter$Value;)V", "_text", "", "argument", "Lcom/intellij/psi/SmartPsiFileRange;", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
public final class DeriveDebugAndChangeFormatToDebugFix
extends RsQuickFixBase<RsExpr> {
    @Nls
    @NotNull
    private final String _text;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiFileRange argument;

    public DeriveDebugAndChangeFormatToDebugFix(@NotNull RsExpr expr, @NotNull FormatParameter.Value parameter) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        super((PsiElement)expr);
        Object[] objectArray = new Object[1];
        RsStructOrEnumItemElement rsStructOrEnumItemElement = ImplKt.baseType(ExtensionsKt.getType(expr));
        if ((rsStructOrEnumItemElement != null ? rsStructOrEnumItemElement.getName() : null) == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        objectArray[0] = objectArray[0];
        this._text = RsBundle.INSTANCE.message("intention.name.derive.debug.and.replace.display.to.debug", objectArray);
        SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)expr.getProject()).createSmartPsiFileRangePointer(expr.getContainingFile(), parameter.getRange());
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        this.argument = smartPsiFileRange;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this._text;
    }

    @Override
    @NotNull
    public String getText() {
        return this._text;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsExpr element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SmartPsiElementPointer<PsiElement> smartPsiElementPointer = ImplKt.baseType(ExtensionsKt.getType(element));
        if (smartPsiElementPointer == null || (smartPsiElementPointer = (SmartPsiElementPointer<PsiElement>)PsiElementKt.findPreviewCopyIfNeeded((PsiElement)smartPsiElementPointer)) == null || (smartPsiElementPointer = UtilsKt.createSmartPointer((PsiElement)smartPsiElementPointer)) == null) {
            return;
        }
        SmartPsiElementPointer<PsiElement> adt = smartPsiElementPointer;
        Segment segment = this.argument.getRange();
        if (segment == null) {
            return;
        }
        Segment range = segment;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Document document = UtilsKt.getDocument(psiFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"{:?}");
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        RsStructOrEnumItemElement rsStructOrEnumItemElement = (RsStructOrEnumItemElement)adt.getElement();
        if (rsStructOrEnumItemElement == null) {
            return;
        }
        DeriveTraitsFix.Companion.invoke(rsStructOrEnumItemElement, "Debug");
    }
}

