/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.PsiModificationUtilsKt;
import org.rust.lang.core.psi.RsBlockFields;
import org.rust.lang.core.psi.RsNamedFieldDecl;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsStructLiteralField;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsStructLiteralFieldKt;
import org.rust.lang.core.psi.ext.RsVisibility;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.resolve.ref.RsPathReferenceImplKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.TypeVisitor;
import org.rust.lang.core.types.regions.ReStatic;
import org.rust.lang.core.types.regions.Region;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyInfer;
import org.rust.lang.core.types.ty.TyOpaque;
import org.rust.lang.core.types.ty.TyProjection;
import org.rust.lang.core.types.ty.TyTypeParameter;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J$\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/rust/ide/fixes/CreateStructFieldFromConstructorFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsStructItem;", "struct", "fieldName", "", "fieldType", "Lorg/rust/lang/core/types/ty/Ty;", "<init>", "(Lorg/rust/lang/core/psi/RsStructItem;Ljava/lang/String;Lorg/rust/lang/core/types/ty/Ty;)V", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "createBlockFields", "Lorg/rust/lang/core/psi/RsBlockFields;", "Lorg/rust/lang/core/psi/RsPsiFactory;", "pub", "", "name", "type", "Companion", "intellij.rustrover.core"})
public final class CreateStructFieldFromConstructorFix
extends RsQuickFixBase<RsStructItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fieldName;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Ty fieldType;

    private CreateStructFieldFromConstructorFix(RsStructItem struct, String fieldName, Ty fieldType) {
        super((PsiElement)struct);
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    @Override
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.create.field", new Object[0]);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsStructItem element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean pub = Intrinsics.areEqual((Object)element.getVisibility(), (Object)RsVisibility.Public.INSTANCE);
        RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
        RsBlockFields structBlockFields = element.getBlockFields();
        if (structBlockFields != null) {
            PsiElement psiElement2 = structBlockFields.getRbrace();
            if (psiElement2 == null) {
                return;
            }
            PsiElement rBrace = psiElement2;
            List<RsNamedFieldDecl> list = structBlockFields.getNamedFieldDeclList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getNamedFieldDeclList(...)");
            PsiModificationUtilsKt.ensureTrailingComma(list);
            PsiElement[] psiElementArray = this.createBlockFields(psiFactory, pub, this.fieldName, this.fieldType).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            structBlockFields.addBefore((PsiElement)ArraysKt.first((Object[])psiElementArray), rBrace);
            v3 = structBlockFields.addBefore(psiFactory.createComma(), rBrace);
        } else {
            PsiElement psiElement3 = element.getIdentifier();
            if (psiElement3 == null) {
                return;
            }
            PsiElement identifier = psiElement3;
            PsiElement psiElement4 = element.addAfter(this.createBlockFields(psiFactory, pub, this.fieldName, this.fieldType), identifier);
            Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsBlockFields");
            RsBlockFields blockFields = (RsBlockFields)psiElement4;
            PsiElement psiElement5 = element.getSemicolon();
            if (psiElement5 != null) {
                psiElement5.delete();
            }
            v3 = blockFields.addBefore(psiFactory.createComma(), blockFields.getRbrace());
        }
    }

    private final RsBlockFields createBlockFields(RsPsiFactory $this$createBlockFields, boolean pub, String name2, Ty type) {
        return $this$createBlockFields.createBlockFields(CollectionsKt.listOf((Object)new RsPsiFactory.BlockField(name2, type, pub)));
    }

    public /* synthetic */ CreateStructFieldFromConstructorFix(RsStructItem struct, String fieldName, Ty fieldType, DefaultConstructorMarker $constructor_marker) {
        this(struct, fieldName, fieldType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/fixes/CreateStructFieldFromConstructorFix$Companion;", "", "<init>", "()V", "tryCreate", "Lorg/rust/ide/fixes/CreateStructFieldFromConstructorFix;", "field", "Lorg/rust/lang/core/psi/RsStructLiteralField;", "resolveToStructItem", "Lorg/rust/lang/core/psi/RsStructItem;", "canUse", "", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CreateStructFieldFromConstructorFix tryCreate(@NotNull RsStructLiteralField field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Object object = field.getIdentifier();
            if (object == null || (object = object.getText()) == null) {
                return null;
            }
            Object fieldName = object;
            Ty fieldType = ExtensionsKt.getType(field);
            if (!this.canUse(fieldType)) {
                return null;
            }
            RsStructItem rsStructItem = this.resolveToStructItem(field);
            if (rsStructItem == null) {
                return null;
            }
            RsStructItem struct = rsStructItem;
            if (struct.getTupleFields() != null) {
                return null;
            }
            RsBlockFields structBlockFields = struct.getBlockFields();
            if (structBlockFields != null && structBlockFields.getRbrace() == null || struct.getIdentifier() == null) {
                return null;
            }
            return new CreateStructFieldFromConstructorFix(struct, (String)fieldName, fieldType, null);
        }

        private final RsStructItem resolveToStructItem(RsStructLiteralField $this$resolveToStructItem) {
            RsPathReference rsPathReference = RsStructLiteralFieldKt.getParentStructLiteral($this$resolveToStructItem).getPath().getReference();
            RsElement rsElement = rsPathReference != null ? RsPathReferenceImplKt.deepResolve(rsPathReference) : null;
            return rsElement instanceof RsStructItem ? (RsStructItem)rsElement : null;
        }

        private final boolean canUse(Ty ty2) {
            boolean result2 = ty2.visitWith(new TypeVisitor(){

                public boolean visitTy(Ty ty2) {
                    Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                    Ty ty3 = ty2;
                    return ty3 instanceof TyUnknown || ty3 instanceof TyTypeParameter || ty3 instanceof TyOpaque || ty3 instanceof TyInfer || ty3 instanceof TyProjection ? true : ty2.superVisitWith(this);
                }

                public boolean visitRegion(Region region) {
                    Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                    return !(region instanceof ReStatic);
                }
            });
            return !result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

