/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.Context;
import org.rust.ide.fixes.CreateLifetimeParameterFromUsageFixKt;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsLifetime;
import org.rust.lang.core.psi.RsLifetimeParameter;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTypeParameterList;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsNameIdentifierOwner;
import org.rust.lang.core.psi.ext.RsTypeParameterListKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/fixes/CreateLifetimeParameterFromUsageFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsLifetime;", "lifetime", "<init>", "(Lorg/rust/lang/core/psi/RsLifetime;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "insertLifetime", "declaration", "Lorg/rust/lang/core/psi/ext/RsGenericDeclaration;", "startElement", "Companion", "intellij.rustrover.core"})
public final class CreateLifetimeParameterFromUsageFix
extends RsQuickFixBase<RsLifetime> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CreateLifetimeParameterFromUsageFix(@NotNull RsLifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super((PsiElement)lifetime);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.create.lifetime.parameter", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsLifetime element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Context context = CreateLifetimeParameterFromUsageFixKt.access$gatherContext(element);
        if (context == null) {
            return;
        }
        Context context2 = context;
        this.insertLifetime(context2.getDeclaration(), project, context2.getLifetime());
    }

    private final void insertLifetime(RsGenericDeclaration declaration, Project project, RsLifetime startElement) {
        RsTypeParameterList originalParams = declaration.getTypeParameterList();
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
        if (originalParams != null) {
            List parameters = new ArrayList();
            List<RsLifetimeParameter> list = originalParams.getLifetimeParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getLifetimeParameterList(...)");
            parameters.addAll((Collection)list);
            parameters.add(startElement);
            parameters.addAll(RsTypeParameterListKt.getRawGenericParameters$default(originalParams, false, false, false, 6, null));
            RsTypeParameterList parameterList = factory2.createTypeParameterList(CollectionsKt.joinToString$default((Iterable)parameters, (CharSequence)", ", null, null, (int)0, null, CreateLifetimeParameterFromUsageFix::insertLifetime$lambda$0, (int)30, null));
            originalParams.replace(parameterList);
        } else {
            String string = startElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            RsTypeParameterList parameterList = factory2.createTypeParameterList(string);
            if (!(declaration instanceof RsNameIdentifierOwner)) {
                return;
            }
            PsiElement nameIdentifier = ((PsiNameIdentifierOwner)declaration).getNameIdentifier();
            if (nameIdentifier != null) {
                declaration.addAfter(parameterList, nameIdentifier);
            }
        }
    }

    private static final CharSequence insertLifetime$lambda$0(RsElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        String string = it2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/fixes/CreateLifetimeParameterFromUsageFix$Companion;", "", "<init>", "()V", "tryCreate", "Lorg/rust/ide/fixes/CreateLifetimeParameterFromUsageFix;", "lifetime", "Lorg/rust/lang/core/psi/RsLifetime;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CreateLifetimeParameterFromUsageFix tryCreate(@NotNull RsLifetime lifetime) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            return CreateLifetimeParameterFromUsageFixKt.access$gatherContext(lifetime) != null ? new CreateLifetimeParameterFromUsageFix(lifetime) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

