/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u001b\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/fixes/ConvertToUnsuffixedIntegerFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsLitExpr;", "element", "textTemplate", "", "<init>", "(Lorg/rust/lang/core/psi/RsLitExpr;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.rustrover.core"})
public final class ConvertToUnsuffixedIntegerFix
extends RsQuickFixBase<RsLitExpr> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String textTemplate;

    private ConvertToUnsuffixedIntegerFix(RsLitExpr element, @IntentionName String textTemplate) {
        super((PsiElement)element);
        this.textTemplate = textTemplate;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.convert.to.unsuffixed.integer", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.textTemplate;
        Object[] objectArray = new Object[]{ConvertToUnsuffixedIntegerFix.Companion.convertToUnsuffixedInteger(this.myStartElement.getElement())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsLitExpr element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = ConvertToUnsuffixedIntegerFix.Companion.convertToUnsuffixedInteger(element);
        if (string == null) {
            return;
        }
        String integer = string;
        RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
        element.replace(psiFactory.createExpression(integer));
    }

    public /* synthetic */ ConvertToUnsuffixedIntegerFix(RsLitExpr element, String textTemplate, DefaultConstructorMarker $constructor_marker) {
        this(element, textTemplate);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000bH\u0003\u00a8\u0006\f"}, d2={"Lorg/rust/ide/fixes/ConvertToUnsuffixedIntegerFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/ConvertToUnsuffixedIntegerFix;", "element", "Lorg/rust/lang/core/psi/RsLitExpr;", "textTemplate", "", "convertToUnsuffixedInteger", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ConvertToUnsuffixedIntegerFix createIfCompatible(@NotNull RsLitExpr element, @IntentionName @NotNull String textTemplate) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)textTemplate, (String)"textTemplate");
            if (this.convertToUnsuffixedInteger(element) != null) {
                return new ConvertToUnsuffixedIntegerFix(element, textTemplate, null);
            }
            return null;
        }

        @IntentionName
        private final String convertToUnsuffixedInteger(PsiElement element) {
            Long l;
            if (element == null) {
                return null;
            }
            if (!(element instanceof RsLitExpr)) {
                return null;
            }
            RsLiteralKind kind2 = RsLiteralKindKt.getKind((RsLitExpr)element);
            if (kind2 instanceof RsLiteralKind.Integer) {
                l = ((RsLiteralKind.Integer)kind2).getValue();
            } else if (kind2 instanceof RsLiteralKind.Boolean) {
                l = null;
            } else if (kind2 instanceof RsLiteralKind.Float) {
                Double d = ((RsLiteralKind.Float)kind2).getValue();
                l = d != null ? Long.valueOf((long)d.doubleValue()) : null;
            } else if (kind2 instanceof RsLiteralKind.String) {
                String string = ((RsLiteralKind.String)kind2).getValue();
                l = string != null ? StringsKt.toLongOrNull((String)string) : null;
            } else if (kind2 instanceof RsLiteralKind.Char) {
                String string = ((RsLiteralKind.Char)kind2).getValue();
                l = string != null ? StringsKt.toLongOrNull((String)string) : null;
            } else if (kind2 == null) {
                l = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (l == null) {
                return null;
            }
            long value = l;
            return String.valueOf(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

