/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.fixes.ConvertToTyUsingTryTraitFix;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRetType;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.RsFunctionOrLambda;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsGenericDeclarationKt;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.resolve.KnownItems;
import org.rust.lang.core.stubs.RsPlaceholderStub;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.TraitRef;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001BR\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012)\u0010\t\u001a%\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\r\u0010\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/fixes/ConvertToTyUsingTryTraitAndUnpackFix;", "Lorg/rust/ide/fixes/ConvertToTyUsingTryTraitFix;", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "errTy", "traitName", "", "fromCallMaker", "Lkotlin/Function4;", "Lorg/rust/lang/core/psi/RsPsiFactory;", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lorg/rust/lang/core/psi/RsExpr;Lorg/rust/lang/core/types/ty/Ty;Lorg/rust/lang/core/types/ty/Ty;Ljava/lang/String;Lkotlin/jvm/functions/Function4;)V", "addFromCall", "", "psiFactory", "fromCall", "findParentFnOrLambdaRetTy", "element", "findParentFunctionOrLambdaRsRetType", "Lorg/rust/lang/core/psi/RsRetType;", "isFnRetTyResultAndMatchErrTy", "", "fnRetTy", "intellij.rustrover.core"})
public abstract class ConvertToTyUsingTryTraitAndUnpackFix
extends ConvertToTyUsingTryTraitFix {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Ty errTy;

    public ConvertToTyUsingTryTraitAndUnpackFix(@NotNull RsExpr expr, @NotNull Ty ty2, @NotNull Ty errTy, @NotNull String traitName, @NotNull Function4<? super ConvertToTyUsingTryTraitFix, ? super RsPsiFactory, ? super RsExpr, ? super Ty, ? extends RsExpr> fromCallMaker) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        Intrinsics.checkNotNullParameter((Object)errTy, (String)"errTy");
        Intrinsics.checkNotNullParameter((Object)traitName, (String)"traitName");
        Intrinsics.checkNotNullParameter(fromCallMaker, (String)"fromCallMaker");
        super(expr, ty2, traitName, fromCallMaker);
        this.errTy = errTy;
    }

    @Override
    public void addFromCall(@NotNull RsPsiFactory psiFactory, @NotNull RsExpr expr, @NotNull RsExpr fromCall) {
        Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)fromCall, (String)"fromCall");
        Ty parentFnRetTy = this.findParentFnOrLambdaRetTy(expr);
        PsiElement psiElement2 = parentFnRetTy != null && this.isFnRetTyResultAndMatchErrTy(expr, parentFnRetTy) ? expr.replace(psiFactory.createTryExpression(fromCall)) : expr.replace(psiFactory.createNoArgsMethodCall(fromCall, "unwrap"));
    }

    private final Ty findParentFnOrLambdaRetTy(RsExpr element) {
        StubBasedPsiElement<RsPlaceholderStub<?>> stubBasedPsiElement = this.findParentFunctionOrLambdaRsRetType(element);
        return stubBasedPsiElement != null && (stubBasedPsiElement = stubBasedPsiElement.getTypeReference()) != null ? ExtensionsKt.getNormType((RsTypeReference)stubBasedPsiElement) : null;
    }

    private final RsRetType findParentFunctionOrLambdaRsRetType(RsExpr element) {
        for (PsiElement parent2 = element.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (!(parent2 instanceof RsFunctionOrLambda)) continue;
            return ((RsFunctionOrLambda)parent2).getRetType();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFnRetTyResultAndMatchErrTy(RsExpr element, Ty fnRetTy) {
        Pair<ImplLookup, KnownItems> pair = ExtensionsKt.getImplLookupAndKnownItems(element);
        ImplLookup lookup2 = (ImplLookup)pair.component1();
        KnownItems items = (KnownItems)pair.component2();
        if (!(fnRetTy instanceof TyAdt)) return false;
        if (!Intrinsics.areEqual((Object)((TyAdt)fnRetTy).getItem(), (Object)items.getResult())) return false;
        RsTraitItem rsTraitItem = items.getFrom();
        if (rsTraitItem == null) {
            return false;
        }
        Ty[] tyArray = new Ty[]{this.errTy};
        if (ImplLookup.select$default(lookup2, new TraitRef(((TyAdt)fnRetTy).getTypeArguments().get(1), RsGenericDeclarationKt.withSubst((RsGenericDeclaration)rsTraitItem, tyArray)), 0, 2, null).ok() == null) return false;
        return true;
    }
}

