/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsIndexExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsIndexExprKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/fixes/ConvertStrIndexToCharsIndexFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lcom/intellij/psi/PsiElement;", "element", "replacement", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFamilyName", "getText", "Companion", "intellij.rustrover.core"})
public final class ConvertStrIndexToCharsIndexFix
extends RsQuickFixBase<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String replacement;

    public ConvertStrIndexToCharsIndexFix(@NotNull PsiElement element, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        super(element);
        this.replacement = replacement;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof RsIndexExpr)) {
            return;
        }
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
        RsExpr newIndexExpr = factory2.createExpression(this.replacement);
        element.replace((PsiElement)newIndexExpr);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.replace.str.index.with.chars.index", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.replacement};
        return RsBundle.INSTANCE.message("intention.name.replace.with2", objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/rust/ide/fixes/ConvertStrIndexToCharsIndexFix$Companion;", "", "<init>", "()V", "create", "", "Lorg/rust/ide/fixes/ConvertStrIndexToCharsIndexFix;", "element", "Lorg/rust/lang/core/psi/RsIndexExpr;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ConvertStrIndexToCharsIndexFix> create(@NotNull RsIndexExpr element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsExpr containerExpr = RsIndexExprKt.getContainerExpr(element);
            RsExpr rsExpr = RsIndexExprKt.getIndexExpr(element);
            if (rsExpr == null) {
                return CollectionsKt.emptyList();
            }
            RsExpr indexExpr = rsExpr;
            ConvertStrIndexToCharsIndexFix[] convertStrIndexToCharsIndexFixArray = new ConvertStrIndexToCharsIndexFix[]{new ConvertStrIndexToCharsIndexFix(element, containerExpr.getText() + ".as_bytes()[" + indexExpr.getText() + "]"), new ConvertStrIndexToCharsIndexFix(element, containerExpr.getText() + ".chars().nth(" + indexExpr.getText() + ").unwrap()")};
            return CollectionsKt.listOf((Object[])convertStrIndexToCharsIndexFixArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

