/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.fixes.AddToOwnedFix;
import org.rust.ide.fixes.RsFixVectorConcatAssignFix;
import org.rust.ide.fixes.RsReplaceWithConcatFix;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.ext.ArithmeticOp;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.core.types.infer.RsInferenceContext;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyRef;
import org.rust.lang.core.types.ty.TySlice;
import org.rust.lang.core.types.ty.TyStr;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a8\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\t\u001a6\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tH\u0002\u001aB\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a&\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tH\u0002\u001a\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a6\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00010\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00160\tH\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0016*\u00020\u0006H\u0002\u001a\f\u0010\u001b\u001a\u00020\u0016*\u00020\u0006H\u0002\u001a\f\u0010\u001c\u001a\u00020\u0016*\u00020\u0006H\u0002\u001a\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u0006*\u00020\u0006H\u0002\u00a8\u0006\u001e"}, d2={"createConcatFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "expr", "Lorg/rust/lang/core/psi/RsBinaryExpr;", "lhsType", "Lorg/rust/lang/core/types/ty/Ty;", "rhsType", "typeProvider", "Lkotlin/Function1;", "Lorg/rust/lang/core/psi/RsExpr;", "createConcatVecFix", "createConcatStringFixes", "", "fixes", "", "createReplaceWithConcatFix", "createReplaceWithFormatMultiple", "createConcatAssignFix", "findRootConcatExpr", "Lkotlin/Pair;", "filter", "", "type", "ctx", "Lorg/rust/lang/core/types/infer/RsInferenceContext;", "isStr", "isString", "isStrOrString", "getSliceOrVecElementType", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nConcatFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcatFix.kt\norg/rust/ide/fixes/ConcatFixKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1740#2,3:156\n1761#2,3:159\n774#2:162\n865#2,2:163\n1#3:165\n*S KotlinDebug\n*F\n+ 1 ConcatFix.kt\norg/rust/ide/fixes/ConcatFixKt\n*L\n80#1:156,3\n81#1:159,3\n87#1:162\n87#1:163,2\n*E\n"})
public final class ConcatFixKt {
    @NotNull
    public static final List<LocalQuickFix> createConcatFixes(@NotNull RsBinaryExpr expr, @NotNull Ty lhsType, @NotNull Ty rhsType, @NotNull Function1<? super RsExpr, ? extends Ty> typeProvider) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
        Intrinsics.checkNotNullParameter((Object)rhsType, (String)"rhsType");
        Intrinsics.checkNotNullParameter(typeProvider, (String)"typeProvider");
        List fixes = new ArrayList();
        ConcatFixKt.createConcatStringFixes(expr, lhsType, rhsType, fixes, typeProvider);
        UtilKt.addIfNotNull((List)fixes, (Object)ConcatFixKt.createConcatVecFix(expr, lhsType, rhsType, typeProvider));
        return fixes;
    }

    private static final LocalQuickFix createConcatVecFix(RsBinaryExpr expr, Ty lhsType, Ty rhsType, Function1<? super RsExpr, ? extends Ty> typeProvider) {
        Ty ty2 = ConcatFixKt.getSliceOrVecElementType(lhsType);
        if (ty2 == null) {
            return null;
        }
        Ty elementType = ty2;
        if (!Intrinsics.areEqual((Object)ConcatFixKt.getSliceOrVecElementType(rhsType), (Object)elementType)) {
            return null;
        }
        Pair<RsExpr, List<RsExpr>> pair = ConcatFixKt.findRootConcatExpr(expr, (Function1<? super RsExpr, Boolean>)((Function1)arg_0 -> ConcatFixKt.createConcatVecFix$lambda$0(typeProvider, elementType, arg_0)));
        RsExpr root = (RsExpr)pair.component1();
        List exprs = (List)pair.component2();
        String result2 = CollectionsKt.joinToString$default((Iterable)exprs, null, (CharSequence)"[", (CharSequence)"].concat()", (int)0, null, ConcatFixKt::createConcatVecFix$lambda$1, (int)25, null);
        return new RsReplaceWithConcatFix(root, result2);
    }

    private static final void createConcatStringFixes(RsBinaryExpr expr, Ty lhsType, Ty rhsType, List<LocalQuickFix> fixes, Function1<? super RsExpr, ? extends Ty> typeProvider) {
        if (ConcatFixKt.isStrOrString(lhsType) && ConcatFixKt.isStrOrString(rhsType)) {
            LocalQuickFix replaceWithConcatFix = ConcatFixKt.createReplaceWithConcatFix(expr);
            if (!ConcatFixKt.isString(lhsType) && replaceWithConcatFix == null) {
                Collection collection = fixes;
                RsExpr rsExpr = expr.getLeft();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getLeft(...)");
                collection.add(new AddToOwnedFix(rsExpr));
            }
            UtilKt.addIfNotNull(fixes, (Object)ConcatFixKt.createReplaceWithFormatMultiple(expr, typeProvider));
            UtilKt.addIfNotNull(fixes, (Object)replaceWithConcatFix);
        }
    }

    private static final LocalQuickFix createReplaceWithConcatFix(RsBinaryExpr expr) {
        RsExpr rsExpr = expr.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getLeft(...)");
        if (!ConcatFixKt.createReplaceWithConcatFix$isStrLiteral(rsExpr)) {
            return null;
        }
        RsExpr rsExpr2 = expr.getRight();
        if (!(rsExpr2 != null ? ConcatFixKt.createReplaceWithConcatFix$isStrLiteral(rsExpr2) : false)) {
            return null;
        }
        Pair<RsExpr, List<RsExpr>> pair = ConcatFixKt.findRootConcatExpr(expr, (Function1<? super RsExpr, Boolean>)((Function1)ConcatFixKt::createReplaceWithConcatFix$lambda$0));
        RsExpr root = (RsExpr)pair.component1();
        List exprs = (List)pair.component2();
        String formatArgs = StringsKt.repeat((CharSequence)"{}", (int)exprs.size());
        String values = CollectionsKt.joinToString$default((Iterable)exprs, (CharSequence)", ", null, null, (int)0, null, ConcatFixKt::createReplaceWithConcatFix$lambda$1, (int)30, null);
        String result2 = "concat!(\"" + formatArgs + "\", " + values + ")";
        return new RsReplaceWithConcatFix(root, result2);
    }

    /*
     * WARNING - void declaration
     */
    private static final LocalQuickFix createReplaceWithFormatMultiple(RsBinaryExpr expr, Function1<? super RsExpr, ? extends Ty> typeProvider) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        boolean bl;
        RsExpr it2;
        List exprs;
        RsExpr root;
        block11: {
            boolean bl2;
            block10: {
                Pair<RsExpr, List<RsExpr>> pair = ConcatFixKt.findRootConcatExpr(expr, (Function1<? super RsExpr, Boolean>)((Function1)arg_0 -> ConcatFixKt.createReplaceWithFormatMultiple$lambda$0(typeProvider, arg_0)));
                root = (RsExpr)pair.component1();
                exprs = (List)pair.component2();
                if (exprs.size() < 3) {
                    return null;
                }
                Iterable $this$all$iv = exprs;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it2 = (RsExpr)element$iv;
                        boolean bl3 = false;
                        if (it2 instanceof RsLitExpr) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return null;
            }
            Iterable $this$any$iv = exprs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it2 = (RsExpr)element$iv;
                    boolean bl4 = false;
                    if (!(it2 instanceof RsLitExpr && ((RsLitExpr)it2).getStringLiteral() == null)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        String formatArgs = CollectionsKt.joinToString$default((Iterable)exprs, (CharSequence)"", null, null, (int)0, null, ConcatFixKt::createReplaceWithFormatMultiple$lambda$3, (int)30, null);
        Iterable iterable = exprs;
        boolean $i$f$filter = false;
        it2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RsExpr it3 = (RsExpr)element$iv$iv;
            boolean bl5 = false;
            if (!(!(it3 instanceof RsLitExpr))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String values = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, ConcatFixKt::createReplaceWithFormatMultiple$lambda$5, (int)30, null);
        String result2 = "format!(\"" + formatArgs + "\"" + values + ")";
        return new RsReplaceWithConcatFix(root, result2);
    }

    @Nullable
    public static final LocalQuickFix createConcatAssignFix(@NotNull RsBinaryExpr expr, @NotNull Ty lhsType) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
        TyAdt tyAdt = lhsType instanceof TyAdt ? (TyAdt)lhsType : null;
        if (!Intrinsics.areEqual((Object)(tyAdt != null ? tyAdt.getItem() : null), (Object)KnownItemsKt.getKnownItems(expr).getVec())) {
            return null;
        }
        return new RsFixVectorConcatAssignFix(expr);
    }

    private static final Pair<RsExpr, List<RsExpr>> findRootConcatExpr(RsBinaryExpr expr, Function1<? super RsExpr, Boolean> filter2) {
        RsBinaryExpr root = expr;
        Object[] objectArray = new RsExpr[2];
        objectArray[0] = root.getLeft();
        Intrinsics.checkNotNull((Object)root.getRight());
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        while (true) {
            RsExpr rsExpr;
            RsExpr rsExpr2;
            RsBinaryExpr parent2;
            PsiElement psiElement2;
            RsBinaryExpr rsBinaryExpr = (psiElement2 = root.getParent()) instanceof RsBinaryExpr ? (RsBinaryExpr)psiElement2 : null;
            if (rsBinaryExpr == null || !Intrinsics.areEqual((Object)RsExprKt.getOperatorType(parent2 = rsBinaryExpr), (Object)ArithmeticOp.ADD.INSTANCE) || (rsExpr2 = parent2.getRight()) == null || (rsExpr2 = (Boolean)filter2.invoke((Object)(rsExpr = rsExpr2)) != false ? rsExpr : null) == null) break;
            RsExpr arg = rsExpr2;
            root = parent2;
            ((Collection)args).add(arg);
        }
        return TuplesKt.to((Object)root, (Object)args);
    }

    private static final Ty type(RsExpr $this$type, RsInferenceContext ctx) {
        return ctx.getExprType($this$type);
    }

    private static final boolean isStr(Ty $this$isStr) {
        TyRef tyRef = $this$isStr instanceof TyRef ? (TyRef)$this$isStr : null;
        return (tyRef != null ? tyRef.getReferenced() : null) instanceof TyStr;
    }

    private static final boolean isString(Ty $this$isString) {
        return $this$isString instanceof TyAdt && Intrinsics.areEqual((Object)((TyAdt)$this$isString).getItem(), (Object)KnownItemsKt.getKnownItems(((TyAdt)$this$isString).getItem()).getString());
    }

    private static final boolean isStrOrString(Ty $this$isStrOrString) {
        return ConcatFixKt.isStr($this$isStrOrString) || ConcatFixKt.isString($this$isStrOrString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Ty getSliceOrVecElementType(Ty $this$getSliceOrVecElementType) {
        Ty ty2;
        if ($this$getSliceOrVecElementType instanceof TyRef && ((TyRef)$this$getSliceOrVecElementType).getReferenced() instanceof TySlice) {
            ty2 = ((TySlice)((TyRef)$this$getSliceOrVecElementType).getReferenced()).getElementType();
            return ty2;
        } else {
            if (!($this$getSliceOrVecElementType instanceof TyAdt)) return null;
            TyAdt tyAdt = (TyAdt)$this$getSliceOrVecElementType;
            TyAdt tyAdt2 = tyAdt;
            if (tyAdt2 == null) return null;
            List<Ty> list = tyAdt2;
            TyAdt it2 = list;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((TyAdt)$this$getSliceOrVecElementType).getItem(), (Object)KnownItemsKt.getKnownItems(((TyAdt)$this$getSliceOrVecElementType).getItem()).getVec())) return null;
            TyAdt tyAdt3 = list;
            TyAdt tyAdt4 = tyAdt3;
            if (tyAdt4 == null) return null;
            list = tyAdt4.getTypeArguments();
            if (list == null) return null;
            ty2 = (Ty)CollectionsKt.firstOrNull((List)list);
        }
        return ty2;
    }

    private static final boolean createConcatVecFix$lambda$0(Function1 $typeProvider, Ty $elementType, RsExpr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return Intrinsics.areEqual((Object)ConcatFixKt.getSliceOrVecElementType((Ty)$typeProvider.invoke((Object)it2)), (Object)$elementType);
    }

    private static final CharSequence createConcatVecFix$lambda$1(RsExpr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        String string = it2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean createReplaceWithConcatFix$isStrLiteral(RsExpr $this$createReplaceWithConcatFix_u24isStrLiteral) {
        return $this$createReplaceWithConcatFix_u24isStrLiteral instanceof RsLitExpr && RsLiteralKindKt.getKind((RsLitExpr)$this$createReplaceWithConcatFix_u24isStrLiteral) instanceof RsLiteralKind.String;
    }

    private static final boolean createReplaceWithConcatFix$lambda$0(RsExpr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return ConcatFixKt.createReplaceWithConcatFix$isStrLiteral(it2);
    }

    private static final CharSequence createReplaceWithConcatFix$lambda$1(RsExpr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        String string = it2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean createReplaceWithFormatMultiple$lambda$0(Function1 $typeProvider, RsExpr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return ConcatFixKt.isStrOrString((Ty)$typeProvider.invoke((Object)it2));
    }

    private static final CharSequence createReplaceWithFormatMultiple$lambda$3(RsExpr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        Object object = it2 instanceof RsLitExpr ? (RsLitExpr)it2 : null;
        return object != null && (object = object.getStringLiteral()) != null && (object = object.getText()) != null && (object = StringsKt.removeSurrounding((String)object, (CharSequence)"\"")) != null ? (CharSequence)object : (CharSequence)"{}";
    }

    private static final CharSequence createReplaceWithFormatMultiple$lambda$5(RsExpr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return ", " + it2.getText();
    }
}

