/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.rust.ide.fixes.ChangeFunctionSignatureFix;
import org.rust.ide.fixes.PeekableIterator;
import org.rust.ide.fixes.Signature;
import org.rust.ide.fixes.SignatureAction;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.ide.refactoring.RsNameSuggestionsKt;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsRecursiveVisitor;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsValueArgumentList;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.RsInferenceContext;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyUnknown;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0002\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a&\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u001a\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006 "}, d2={"formatParameter", "", "Lorg/rust/lang/core/psi/RsPat;", "index", "", "suggestName", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "generateName", "defaultName", "usedNames", "", "calculateSignatureWithInsertion", "Lorg/rust/ide/fixes/Signature;", "function", "Lorg/rust/lang/core/psi/RsFunction;", "argumentList", "Lorg/rust/lang/core/psi/RsValueArgumentList;", "direction", "Lorg/rust/ide/fixes/ChangeFunctionSignatureFix$ArgumentScanDirection;", "calculateSignatureWithoutInsertion", "args", "errorArguments", "", "Lcom/intellij/psi/PsiElement;", "getEffectiveArguments", "", "renderType", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "getExistingParameterNames", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nChangeFunctionSignatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeFunctionSignatureFix.kt\norg/rust/ide/fixes/ChangeFunctionSignatureFixKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n1563#2:372\n1634#2,3:373\n*S KotlinDebug\n*F\n+ 1 ChangeFunctionSignatureFix.kt\norg/rust/ide/fixes/ChangeFunctionSignatureFixKt\n*L\n243#1:372\n243#1:373,3\n*E\n"})
public final class ChangeFunctionSignatureFixKt {
    private static final String formatParameter(RsPat $this$formatParameter, int index) {
        String string;
        if ($this$formatParameter instanceof RsPatIdent) {
            string = "parameter `" + ((RsPatIdent)$this$formatParameter).getPatBinding().getName() + "`";
        } else {
            int num = index + 1;
            string = "`" + num + UtilsKt.numberSuffix(num) + "` parameter";
        }
        return string;
    }

    private static final String suggestName(RsExpr expr) {
        if (expr instanceof RsPathExpr) {
            String name2;
            RsPathReference rsPathReference = ((RsPathExpr)expr).getPath().getReference();
            RsElement reference = rsPathReference != null ? rsPathReference.resolve() : null;
            RsPatBinding rsPatBinding = reference instanceof RsPatBinding ? (RsPatBinding)reference : null;
            String string = name2 = rsPatBinding != null ? rsPatBinding.getName() : null;
            if (name2 != null) {
                return name2;
            }
        }
        return RsNameSuggestionsKt.suggestedNames(expr).getDefault();
    }

    private static final String generateName(String defaultName, Set<String> usedNames) {
        Object name2 = defaultName;
        int index = 0;
        while (usedNames.contains(name2)) {
            name2 = defaultName + index;
            ++index;
        }
        usedNames.add((String)name2);
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Signature calculateSignatureWithInsertion(RsFunction function, RsValueArgumentList argumentList, ChangeFunctionSignatureFix.ArgumentScanDirection direction) {
        RsValueParameter parameter;
        List<RsValueParameter> parameters = RsFunctionKt.getValueParameters(function);
        List<RsExpr> arguments = ChangeFunctionSignatureFixKt.getEffectiveArguments(argumentList, function);
        if (parameters.isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)arguments);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SignatureAction.InsertArgument((int)it2));
            }
            List list = (List)destination$iv$iv;
            return new Signature(list);
        }
        RsInferenceContext ctx = ExtensionsKt.getImplLookup(function).getCtx();
        PeekableIterator<RsValueParameter> parameterIterator = ChangeFunctionSignatureFixKt.calculateSignatureWithInsertion$createIterator(direction, parameters);
        PeekableIterator<RsExpr> argumentIterator = ChangeFunctionSignatureFixKt.calculateSignatureWithInsertion$createIterator(direction, arguments);
        List insertions = new ArrayList();
        while (true) {
            RsExpr argument;
            parameter = parameterIterator.getValue();
            if (argumentIterator.getValue() == null) break;
            if (parameter != null) {
                Object object = parameter.getTypeReference();
                if (object == null || (object = ExtensionsKt.normType((RsTypeReference)object, ctx)) == null) {
                    object = TyUnknown.INSTANCE;
                }
                if (ctx.combineTypes((Ty)object, ExtensionsKt.getType(argument)).isOk()) {
                    insertions.add(new SignatureAction.KeepParameter(parameters.indexOf(parameter)));
                    parameterIterator.advance();
                    argumentIterator.advance();
                    continue;
                }
            }
            insertions.add(new SignatureAction.InsertArgument(arguments.indexOf(argument)));
            argumentIterator.advance();
        }
        while (parameterIterator.getValue() != null) {
            insertions.add(new SignatureAction.KeepParameter(parameters.indexOf(parameter)));
            parameterIterator.advance();
        }
        return new Signature(CollectionsKt.toList(direction.map(insertions)));
    }

    private static final Signature calculateSignatureWithoutInsertion(RsFunction function, RsValueArgumentList args, Set<? extends PsiElement> errorArguments) {
        List actions = new ArrayList();
        List<RsValueParameter> parameters = RsFunctionKt.getValueParameters(function);
        List<RsExpr> arguments = ChangeFunctionSignatureFixKt.getEffectiveArguments(args, function);
        int length = Math.max(arguments.size(), parameters.size());
        for (int index = 0; index < length; ++index) {
            SignatureAction action2 = index >= arguments.size() ? (SignatureAction)SignatureAction.RemoveParameter.INSTANCE : (index >= parameters.size() ? (SignatureAction)new SignatureAction.InsertArgument(index) : (errorArguments.contains(arguments.get(index)) ? (SignatureAction)new SignatureAction.ChangeParameterType(index) : (SignatureAction)new SignatureAction.KeepParameter(index)));
            actions.add(action2);
        }
        return new Signature(actions);
    }

    private static final List<RsExpr> getEffectiveArguments(RsValueArgumentList args, RsFunction function) {
        List list = args.getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        List arguments = list;
        boolean isUFCS = RsFunctionKt.isMethod(function) && args.getParent() instanceof RsCallExpr;
        return isUFCS ? CollectionsKt.drop((Iterable)arguments, (int)1) : arguments;
    }

    private static final String renderType(Ty ty2) {
        return TypeRenderingKt.renderInsertionSafe$default(ty2, null, 0, null, false, false, false, false, 127, null);
    }

    private static final void getExistingParameterNames(Set<String> usedNames, RsFunction function) {
        block0: {
            RsRecursiveVisitor visitor2 = new RsRecursiveVisitor(usedNames){
                final /* synthetic */ Set<String> $usedNames;
                {
                    this.$usedNames = $usedNames;
                }

                public void visitPatBinding(RsPatBinding o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    String name2 = o.getIdentifier().getText();
                    Intrinsics.checkNotNull((Object)name2);
                    this.$usedNames.add(name2);
                }
            };
            RsValueParameterList rsValueParameterList = function.getValueParameterList();
            if (rsValueParameterList == null) break block0;
            rsValueParameterList.acceptChildren(visitor2);
        }
    }

    private static final <T> PeekableIterator<T> calculateSignatureWithInsertion$createIterator(ChangeFunctionSignatureFix.ArgumentScanDirection $direction, List<? extends T> items) {
        return new PeekableIterator($direction.map((Iterable)items).iterator());
    }

    public static final /* synthetic */ void access$getExistingParameterNames(Set usedNames, RsFunction function) {
        ChangeFunctionSignatureFixKt.getExistingParameterNames(usedNames, function);
    }

    public static final /* synthetic */ List access$getEffectiveArguments(RsValueArgumentList args, RsFunction function) {
        return ChangeFunctionSignatureFixKt.getEffectiveArguments(args, function);
    }

    public static final /* synthetic */ String access$renderType(Ty ty2) {
        return ChangeFunctionSignatureFixKt.renderType(ty2);
    }

    public static final /* synthetic */ String access$generateName(String defaultName, Set usedNames) {
        return ChangeFunctionSignatureFixKt.generateName(defaultName, usedNames);
    }

    public static final /* synthetic */ String access$suggestName(RsExpr expr) {
        return ChangeFunctionSignatureFixKt.suggestName(expr);
    }

    public static final /* synthetic */ Signature access$calculateSignatureWithInsertion(RsFunction function, RsValueArgumentList argumentList, ChangeFunctionSignatureFix.ArgumentScanDirection direction) {
        return ChangeFunctionSignatureFixKt.calculateSignatureWithInsertion(function, argumentList, direction);
    }

    public static final /* synthetic */ Signature access$calculateSignatureWithoutInsertion(RsFunction function, RsValueArgumentList args, Set errorArguments) {
        return ChangeFunctionSignatureFixKt.calculateSignatureWithoutInsertion(function, args, errorArguments);
    }

    public static final /* synthetic */ String access$formatParameter(RsPat $receiver, int index) {
        return ChangeFunctionSignatureFixKt.formatParameter($receiver, index);
    }
}

