/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.ide.fixes.AttachFileToModuleFixKt;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.lang.core.psi.RsModDeclItem;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/fixes/AttachFileToModuleFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "file", "Lorg/rust/lang/core/psi/RsFile;", "targetModuleName", "", "<init>", "(Lorg/rust/lang/core/psi/RsFile;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "startInWriteAction", "", "Companion", "intellij.rustrover.core"})
public final class AttachFileToModuleFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String targetModuleName;

    public AttachFileToModuleFix(@NotNull RsFile file, @Nullable String targetModuleName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super((PsiElement)file);
        this.targetModuleName = targetModuleName;
    }

    public /* synthetic */ AttachFileToModuleFix(RsFile rsFile, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(rsFile, string);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[1];
        String string = this.targetModuleName;
        if (string == null) {
            string = "a module";
        }
        objectArray[0] = string;
        return RsBundle.INSTANCE.message("intention.name.attach.file.to", objectArray);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        RsFile rsFile = startElement instanceof RsFile ? (RsFile)startElement : null;
        if (rsFile == null) {
            return;
        }
        RsFile rsFile2 = rsFile;
        Companion.invokeFix(project, rsFile2, this.getFamilyName());
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bJ%\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u000b\u0010\u0010\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/fixes/AttachFileToModuleFix$Companion;", "", "<init>", "()V", "invokeFix", "", "project", "Lcom/intellij/openapi/project/Project;", "rsFile", "Lorg/rust/lang/core/psi/RsFile;", "text", "", "insertFileToModule", "Lorg/rust/lang/core/psi/RsModDeclItem;", "file", "targetFile", "commandName", "Lorg/jetbrains/annotations/Nls;", "createIfCompatible", "Lorg/rust/ide/fixes/AttachFileToModuleFix;", "findAvailableModulesForFile", "", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nAttachFileToModuleFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachFileToModuleFix.kt\norg/rust/ide/fixes/AttachFileToModuleFix$Companion\n+ 2 Utils.kt\norg/rust/stdext/UtilsKt\n+ 3 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n34#2:226\n31#3:227\n1761#4,3:228\n1#5:231\n*S KotlinDebug\n*F\n+ 1 AttachFileToModuleFix.kt\norg/rust/ide/fixes/AttachFileToModuleFix$Companion\n*L\n78#1:226\n93#1:227\n93#1:228,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void invokeFix(@NotNull Project project, @NotNull RsFile rsFile, @Nls @NotNull String text) {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rsFile, (String)"rsFile");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            List<RsFile> availableModules = this.findAvailableModulesForFile(project, rsFile);
            RsCounterUsagesCollector.INSTANCE.logFileAttachedToModule(project, availableModules.size());
            switch (availableModules.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    RsModDeclItem rsModDeclItem = this.insertFileToModule(rsFile, availableModules.get(0), text);
                    if (rsModDeclItem != null) {
                        rsModDeclItem.navigate(true);
                        unit = Unit.INSTANCE;
                        break;
                    }
                    unit = null;
                    break;
                }
                default: {
                    RsFile rsFile2 = AttachFileToModuleFixKt.access$selectModule(rsFile, availableModules);
                    if (rsFile2 != null) {
                        RsFile it2 = rsFile2;
                        boolean bl = false;
                        RsModDeclItem rsModDeclItem = Companion.insertFileToModule(rsFile, it2, text);
                        if (rsModDeclItem != null) {
                            rsModDeclItem.navigate(true);
                            unit = Unit.INSTANCE;
                            break;
                        }
                        unit = null;
                        break;
                    }
                    unit = null;
                }
            }
            Unit unit2 = unit;
            boolean $i$f$getExhaustive = false;
        }

        @Nullable
        public final RsModDeclItem insertFileToModule(@NotNull RsFile file, @NotNull RsFile targetFile, @NotNull String commandName) {
            boolean bl;
            String name2;
            RsPsiFactory factory2;
            Project project;
            block5: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
                Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
                Project project2 = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                factory2 = new RsPsiFactory(project, false, false, 6, null);
                String string = AttachFileToModuleFixKt.access$isModuleFile(file) ? file.getVirtualFile().getParent().getName() : file.getVirtualFile().getNameWithoutExtension();
                Intrinsics.checkNotNull((Object)string);
                name2 = string;
                PsiElement $this$childrenOfType$iv = targetFile;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, RsModDeclItem.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RsModDeclItem it2 = (RsModDeclItem)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it2.getReferenceName(), (Object)name2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            RsModDeclItem modItem = factory2.tryCreateModDeclItem(name2);
            if (modItem == null) {
                Object[] objectArray = new Object[]{name2};
                org.rust.ide.notifications.UtilsKt.showBalloon$default(project, "failed.to.create.mod", RsBundle.INSTANCE.message("notification.content.could.not.create.mod", objectArray), NotificationType.ERROR, null, 8, null);
                return null;
            }
            PsiFile[] psiFileArray = new PsiFile[]{targetFile};
            return (RsModDeclItem)UtilsKt.runWriteCommandAction(project, commandName, psiFileArray, () -> Companion.insertFileToModule$lambda$1(modItem, targetFile));
        }

        @Nullable
        public final AttachFileToModuleFix createIfCompatible(@NotNull Project project, @NotNull RsFile file) {
            AttachFileToModuleFix attachFileToModuleFix;
            List<RsFile> list;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            List<RsFile> it2 = list = this.findAvailableModulesForFile(project, file);
            boolean bl = false;
            List<RsFile> list2 = !((Collection)it2).isEmpty() ? list : null;
            if (list2 != null) {
                it2 = list2;
                boolean bl2 = false;
                RsFile rsFile = (RsFile)CollectionsKt.singleOrNull(it2);
                attachFileToModuleFix = new AttachFileToModuleFix(file, rsFile != null ? rsFile.getName() : null);
            } else {
                attachFileToModuleFix = null;
            }
            return attachFileToModuleFix;
        }

        @NotNull
        public final List<RsFile> findAvailableModulesForFile(@NotNull Project project, @NotNull RsFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile virtualFile2 = virtualFile;
            CargoWorkspace.Package package_ = CargoProjectServiceKt.getCargoProjects(project).findPackageForFile(virtualFile2);
            if (package_ == null) {
                return CollectionsKt.emptyList();
            }
            CargoWorkspace.Package pkg = package_;
            VirtualFile virtualFile3 = virtualFile2.getParent();
            if (virtualFile3 == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile directory = virtualFile3;
            List modules = new ArrayList();
            if (AttachFileToModuleFixKt.access$isModuleFile(file)) {
                VirtualFile virtualFile4;
                VirtualFile virtualFile5 = directory.getParent();
                UtilKt.addIfNotNull((List)modules, (Object)AttachFileToModuleFixKt.access$findModule(file, project, (VirtualFile)(virtualFile5 != null ? virtualFile5.findFileByRelativePath("mod.rs") : null)));
                VirtualFile virtualFile6 = directory.getParent();
                if (virtualFile6 != null && (virtualFile6 = virtualFile6.getParent()) != null) {
                    VirtualFile virtualFile7 = directory.getParent();
                    virtualFile4 = virtualFile6.findFileByRelativePath((virtualFile7 != null ? virtualFile7.getName() : null) + ".rs");
                } else {
                    virtualFile4 = null;
                }
                UtilKt.addIfNotNull((List)modules, (Object)AttachFileToModuleFixKt.access$findModule(file, project, virtualFile4));
                for (CargoWorkspace.Target target : pkg.getTargets()) {
                    VirtualFile crateRoot;
                    if (target.getCrateRoot() == null || !Intrinsics.areEqual((Object)crateRoot.getParent(), (Object)directory.getParent())) continue;
                    PsiFile psiFile = UtilsKt.toPsiFile(crateRoot, project);
                    UtilKt.addIfNotNull((List)modules, (Object)(psiFile != null ? RsFileKt.getRustFile(psiFile) : null));
                }
            } else {
                UtilKt.addIfNotNull((List)modules, (Object)AttachFileToModuleFixKt.access$findModule(file, project, directory.findFileByRelativePath("mod.rs")));
                if (pkg.getEdition().compareTo((Enum)CargoWorkspace.Edition.EDITION_2018) >= 0) {
                    VirtualFile virtualFile8 = directory.getParent();
                    UtilKt.addIfNotNull((List)modules, (Object)AttachFileToModuleFixKt.access$findModule(file, project, virtualFile8 != null ? virtualFile8.findFileByRelativePath(directory.getName() + ".rs") : null));
                }
                for (CargoWorkspace.Target target : pkg.getTargets()) {
                    VirtualFile crateRoot;
                    if (target.getCrateRoot() == null || !Intrinsics.areEqual((Object)crateRoot.getParent(), (Object)directory)) continue;
                    PsiFile psiFile = UtilsKt.toPsiFile(crateRoot, project);
                    UtilKt.addIfNotNull((List)modules, (Object)(psiFile != null ? RsFileKt.getRustFile(psiFile) : null));
                }
            }
            return modules;
        }

        private static final RsModDeclItem insertFileToModule$lambda$1(RsModDeclItem $modItem, RsFile $targetFile) {
            return AttachFileToModuleFixKt.access$insertModItem($modItem, $targetFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

