/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.toolchain.impl.Applicability;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J3\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0096\u0002J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/rust/ide/fixes/ApplySuggestionFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "message", "", "replacement", "applicability", "Lorg/rust/cargo/toolchain/impl/Applicability;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "range", "Lcom/intellij/psi/SmartPsiFileRange;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/rust/cargo/toolchain/impl/Applicability;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/SmartPsiFileRange;)V", "getApplicability", "()Lorg/rust/cargo/toolchain/impl/Applicability;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "equals", "", "other", "", "hashCode", "", "intellij.rustrover.core"})
public final class ApplySuggestionFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements LowPriorityAction {
    @NotNull
    private final String message;
    @NotNull
    private final String replacement;
    @NotNull
    private final Applicability applicability;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiFileRange range;

    public ApplySuggestionFix(@NotNull String message, @NotNull String replacement, @NotNull Applicability applicability, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull SmartPsiFileRange range) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        Intrinsics.checkNotNullParameter((Object)((Object)applicability), (String)"applicability");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(startElement, endElement);
        this.message = message;
        this.replacement = replacement;
        this.applicability = applicability;
        this.range = range;
    }

    @NotNull
    public final Applicability getApplicability() {
        return this.applicability;
    }

    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.apply.suggested.replacement.made.by.external.linter", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.message};
        return RsBundle.INSTANCE.message("intention.name.external.linter", objectArray);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiFile psiFile2 = startElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        Document document = UtilsKt.getDocument(psiFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        Segment segment = this.range.getRange();
        if (segment == null) {
            return;
        }
        Segment range = segment;
        document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)this.replacement);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.rust.ide.fixes.ApplySuggestionFix");
        ApplySuggestionFix cfr_ignored_0 = (ApplySuggestionFix)((Object)object2);
        if (!Intrinsics.areEqual((Object)this.message, (Object)((ApplySuggestionFix)((Object)other)).message)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.replacement, (Object)((ApplySuggestionFix)((Object)other)).replacement)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myStartElement, (Object)((ApplySuggestionFix)((Object)other)).myStartElement)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.myEndElement, (Object)((ApplySuggestionFix)((Object)other)).myEndElement);
    }

    public int hashCode() {
        int result2 = this.message.hashCode();
        result2 = 31 * result2 + this.replacement.hashCode();
        SmartPsiElementPointer smartPsiElementPointer = this.myStartElement;
        result2 = 31 * result2 + (smartPsiElementPointer != null ? smartPsiElementPointer.hashCode() : 0);
        SmartPsiElementPointer smartPsiElementPointer2 = this.myEndElement;
        result2 = 31 * result2 + (smartPsiElementPointer2 != null ? smartPsiElementPointer2.hashCode() : 0);
        return result2;
    }
}

