/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.ide.utils.template.EditorExtKt;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.types.ty.Ty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/fixes/AddTypeFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lcom/intellij/psi/PsiElement;", "anchor", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/rust/lang/core/types/ty/Ty;)V", "typeText", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
public final class AddTypeFix
extends RsQuickFixBase<PsiElement> {
    @NotNull
    private final String typeText;

    public AddTypeFix(@NotNull PsiElement anchor, @NotNull Ty ty2) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        super(anchor);
        this.typeText = TypeRenderingKt.renderInsertionSafe$default(ty2, null, 0, null, false, false, false, false, 127, null);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.add.type", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.typeText};
        return RsBundle.INSTANCE.message("intention.name.add.type", objectArray);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
            PsiElement parent2 = element.getParent();
            PsiElement colon = factory2.createColon();
            PsiElement anchor = parent2.addAfter(colon, element);
            RsTypeReference type = factory2.createType(this.typeText);
            PsiElement insertedType = parent2.addAfter((PsiElement)type, anchor);
            Editor editor3 = editor2;
            if (editor3 == null) break block0;
            Intrinsics.checkNotNull((Object)parent2);
            EditorExtKt.buildAndRunTemplate$default(editor3, parent2, CollectionsKt.listOf((Object)insertedType), null, 4, null);
        }
    }
}

