/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsParenExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTupleExpr;
import org.rust.lang.core.psi.RsUnitExpr;
import org.rust.lang.core.psi.ext.ArithmeticOp;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/fixes/AddTurbofishFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lcom/intellij/psi/PsiElement;", "leaf", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Companion", "intellij.rustrover.core"})
public final class AddTurbofishFix
extends RsQuickFixBase<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TURBOFISH = "::";

    public AddTurbofishFix(@NotNull PsiElement leaf) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        super(leaf);
    }

    @Override
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.add.turbofish.operator", new Object[0]);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Document document = UtilsKt.getDocument(psiFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        document2.insertString(PsiElementKt.getStartOffset(element), (CharSequence)TURBOFISH);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\b\u0010\u0006\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u0016H\u0002J\f\u0010\u001f\u001a\u00020\u001a*\u00020\nH\u0002R\u000e\u0010 \u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/rust/ide/fixes/AddTurbofishFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/AddTurbofishFix;", "expr", "Lorg/rust/lang/core/psi/RsBinaryExpr;", "findMatchExpression", "element", "Lcom/intellij/psi/PsiElement;", "innerOffset", "", "root", "child", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "findOffset", "project", "Lcom/intellij/openapi/project/Project;", "binary", "(Lcom/intellij/openapi/project/Project;Lorg/rust/lang/core/psi/RsBinaryExpr;)Ljava/lang/Integer;", "rightBoundary", "Lorg/rust/lang/core/psi/RsExpr;", "nodes", "", "isTypeArgumentList", "", "candidate", "", "bfsLeafs", "isCallExpression", "isParenLikeExpr", "TURBOFISH", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nAddTurbofishFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddTurbofishFix.kt\norg/rust/ide/fixes/AddTurbofishFix$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1#2:99\n9#3:100\n967#4,7:101\n295#4,2:108\n*S KotlinDebug\n*F\n+ 1 AddTurbofishFix.kt\norg/rust/ide/fixes/AddTurbofishFix$Companion\n*L\n37#1:100\n62#1:101,7\n74#1:108,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AddTurbofishFix createIfCompatible(@NotNull RsBinaryExpr expr) {
            PsiElement psiElement2;
            block6: {
                block5: {
                    PsiElement psiElement3;
                    Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                    RsBinaryExpr rsBinaryExpr = this.findMatchExpression(RsExprKt.getOperator(expr));
                    if (rsBinaryExpr == null) {
                        return null;
                    }
                    RsBinaryExpr matchExpr2 = rsBinaryExpr;
                    Project project = expr.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Integer n = this.findOffset(project, matchExpr2);
                    if (n == null) {
                        return null;
                    }
                    int offset = n;
                    PsiElement psiElement4 = matchExpr2.findElementAt(offset);
                    if (psiElement4 == null) break block5;
                    PsiElement it2 = psiElement3 = psiElement4;
                    boolean bl = false;
                    Object object = psiElement2 = Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(it2), (Object)RsElementTypes.LT) ? psiElement3 : null;
                    if (psiElement2 != null) break block6;
                }
                return null;
            }
            PsiElement leaf = psiElement2;
            return new AddTurbofishFix(leaf);
        }

        private final RsBinaryExpr findMatchExpression(PsiElement element) {
            PsiElement $this$ancestorStrict$iv = element;
            boolean $i$f$ancestorStrict = false;
            RsBinaryExpr rsBinaryExpr = (RsBinaryExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsBinaryExpr.class, (boolean)true);
            if (rsBinaryExpr == null) {
                return null;
            }
            RsBinaryExpr base = rsBinaryExpr;
            if (!(base.getLeft() instanceof RsBinaryExpr)) {
                RsBinaryExpr rsBinaryExpr2 = this.findMatchExpression(base);
                if (rsBinaryExpr2 == null) {
                    rsBinaryExpr2 = base;
                }
                return rsBinaryExpr2;
            }
            RsExpr rsExpr = base.getLeft();
            Intrinsics.checkNotNull((Object)rsExpr, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsBinaryExpr");
            RsBinaryExpr left = (RsBinaryExpr)rsExpr;
            if (Intrinsics.areEqual((Object)RsExprKt.getOperatorType(left), (Object)ArithmeticOp.SHR.INSTANCE)) {
                RsBinaryExpr rsBinaryExpr3 = this.findMatchExpression(base);
                if (rsBinaryExpr3 == null) {
                    rsBinaryExpr3 = base;
                }
                return rsBinaryExpr3;
            }
            return base;
        }

        private final Integer innerOffset(PsiElement root, PsiElement child) {
            if (Intrinsics.areEqual((Object)child, (Object)root)) {
                return 0;
            }
            PsiElement psiElement2 = child.getParent();
            if (psiElement2 == null) {
                return null;
            }
            PsiElement parent2 = psiElement2;
            Integer n = this.innerOffset(root, parent2);
            if (n == null) {
                return null;
            }
            int upper = n;
            return upper + child.getStartOffsetInParent();
        }

        private final Integer findOffset(Project project, RsBinaryExpr binary) {
            Integer n;
            block4: {
                List<RsExpr> nodes = this.bfsLeafs(binary);
                RsExpr rsExpr = this.rightBoundary(nodes);
                if (rsExpr == null) {
                    return null;
                }
                RsExpr called = rsExpr;
                int typeListEndIndex = binary.getTextLength() - called.getTextLength();
                Iterable $this$takeWhile$iv = nodes;
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    RsExpr it2 = (RsExpr)item$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it2, (Object)called))) break;
                    list$iv.add(item$iv);
                }
                for (RsExpr it3 : (Iterable)list$iv) {
                    String typeListCandidate;
                    boolean bl = false;
                    Integer n2 = Companion.innerOffset(binary, it3);
                    Intrinsics.checkNotNull((Object)n2);
                    int offset = n2 + it3.getTextLength();
                    String string = binary.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)string.substring(offset, typeListEndIndex), (String)"substring(...)");
                    Integer n3 = Companion.isTypeArgumentList(project, typeListCandidate) ? Integer.valueOf(offset) : null;
                    if (n3 == null) continue;
                    n = n3;
                    break block4;
                }
                n = null;
            }
            if (n == null) {
                return null;
            }
            int turbofishOffset = n;
            return turbofishOffset;
        }

        private final RsExpr rightBoundary(List<? extends RsExpr> nodes) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = CollectionsKt.asReversed(nodes);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RsExpr it2 = (RsExpr)element$iv;
                    boolean bl = false;
                    if (!Companion.isCallExpression(it2)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final boolean isTypeArgumentList(Project project, String candidate) {
            return new RsPsiFactory(project, false, false, 6, null).createExpression("something::" + candidate + "()") instanceof RsCallExpr;
        }

        private final List<RsExpr> bfsLeafs(RsExpr expr) {
            RsExpr rsExpr = expr;
            return rsExpr instanceof RsBinaryExpr ? CollectionsKt.plus((Collection)this.bfsLeafs(((RsBinaryExpr)expr).getLeft()), (Iterable)this.bfsLeafs(((RsBinaryExpr)expr).getRight())) : (rsExpr == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)expr));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCallExpression(RsExpr expr) {
            if (this.isParenLikeExpr(expr)) return true;
            PsiElement psiElement2 = expr.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getFirstChild(...)");
            if (!this.isParenLikeExpr(psiElement2)) return false;
            return true;
        }

        private final boolean isParenLikeExpr(PsiElement $this$isParenLikeExpr) {
            return $this$isParenLikeExpr instanceof RsUnitExpr || $this$isParenLikeExpr instanceof RsParenExpr || $this$isParenLikeExpr instanceof RsTupleExpr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

