/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsExternAbi;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.Attribute;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.openapiext.UtilsKt;
import org.rust.toml.CrateExtKt;
import org.rust.toml.UtilKt;
import org.rust.toml.psi.CargoFile;
import org.rust.toml.psi.CargoTomlDependencyType;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/rust/ide/fixes/AddTokioMainFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsFunction;", "function", "<init>", "(Lorg/rust/lang/core/psi/RsFunction;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "requiresCargoChanges", "", "containingCrate", "Lorg/rust/lang/core/crate/Crate;", "Companion", "intellij.rustrover.core"})
public final class AddTokioMainFix
extends RsQuickFixBase<RsFunction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> REQUIRED_TOKIO_FEATURES;

    public AddTokioMainFix(@NotNull RsFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super((PsiElement)function);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.name.add.tokio.main", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.add.tokio.main", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsFunction element) {
        PsiElement anchor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!RsFunctionKt.isAsync(element)) {
            PsiElement psiElement2 = element.getUnsafe();
            if (psiElement2 == null) {
                RsExternAbi rsExternAbi = element.getExternAbi();
                if (rsExternAbi != null) {
                    psiElement2 = rsExternAbi;
                } else {
                    PsiElement psiElement3 = element.getFn();
                    psiElement2 = psiElement3;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFn(...)");
                }
            }
            anchor = psiElement2;
            element.addBefore(new RsPsiFactory(project, false, false, 6, null).createAsyncKeyword(), anchor);
        }
        RsOuterAttr rsOuterAttr = (RsOuterAttr)CollectionsKt.firstOrNull(element.getOuterAttrList());
        anchor = rsOuterAttr != null ? (PsiElement)rsOuterAttr : RsFunctionKt.getFirstKeyword(element);
        RsDocAndAttributeOwnerKt.addOuterAttribute(element, new Attribute("tokio::main", null, 2, null), anchor);
        if (!PsiElementKt.isIntentionPreviewElement(element) && this.requiresCargoChanges(element.getContainingCrate())) {
            CargoFile cargoFile = element.getContainingCrate().getCargoToml();
            if (cargoFile == null) {
                return;
            }
            CargoFile tomlFile = cargoFile;
            List<String> requiredFeatures = UtilKt.findDependencyFeatures(tomlFile.getFile(), "tokio").contains("full") ? CollectionsKt.emptyList() : REQUIRED_TOKIO_FEATURES;
            tomlFile.addCrateToDependency("tokio", requiredFeatures, CargoTomlDependencyType.NORMAL, "1.0.0");
            UtilsKt.refresh(project);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        IntentionPreviewInfo intentionPreviewInfo;
        Crate containingCrate;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        RsFile rsFile = psiFile instanceof RsFile ? (RsFile)psiFile : null;
        Crate crate = containingCrate = rsFile != null ? rsFile.getContainingCrate() : null;
        if (containingCrate != null && this.requiresCargoChanges(containingCrate)) {
            intentionPreviewInfo = (IntentionPreviewInfo)new IntentionPreviewInfo.Html(RsBundle.INSTANCE.message("intention.name.install.tokio.and.add.main", new Object[0]));
        } else {
            IntentionPreviewInfo intentionPreviewInfo2 = super.generatePreview(project, editor2, psiFile);
            Intrinsics.checkNotNull((Object)intentionPreviewInfo2);
            intentionPreviewInfo = intentionPreviewInfo2;
        }
        return intentionPreviewInfo;
    }

    private final boolean requiresCargoChanges(Crate containingCrate) {
        Object object = CrateExtKt.getTomlFile(containingCrate);
        if (object == null || (object = UtilKt.findDependencyFeatures((TomlFile)object, "tokio")) == null) {
            return true;
        }
        Object tokioFeatures = object;
        return !tokioFeatures.contains("full") && !tokioFeatures.containsAll((Collection)REQUIRED_TOKIO_FEATURES);
    }

    static {
        Object[] objectArray = new String[]{"rt", "rt-multi-thread", "macros"};
        REQUIRED_TOKIO_FEATURES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/rust/ide/fixes/AddTokioMainFix$Companion;", "", "<init>", "()V", "REQUIRED_TOKIO_FEATURES", "", "", "getREQUIRED_TOKIO_FEATURES", "()Ljava/util/List;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getREQUIRED_TOKIO_FEATURES() {
            return REQUIRED_TOKIO_FEATURES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

