/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsSelfParameterKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/fixes/AddSelfFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsFunction;", "function", "selfType", "Lorg/rust/ide/fixes/AddSelfFix$SelfType;", "<init>", "(Lorg/rust/lang/core/psi/RsFunction;Lorg/rust/ide/fixes/AddSelfFix$SelfType;)V", "elementName", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "SelfType", "intellij.rustrover.core"})
public final class AddSelfFix
extends RsQuickFixBase<RsFunction> {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SelfType selfType;
    @NotNull
    private final String elementName;

    public AddSelfFix(@NotNull RsFunction function, @NotNull SelfType selfType) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)selfType, (String)"selfType");
        super((PsiElement)function);
        this.selfType = selfType;
        this.elementName = RsAbstractableKt.getOwner(function) instanceof RsAbstractableOwner.Impl ? "function" : "trait";
    }

    public /* synthetic */ AddSelfFix(RsFunction rsFunction, SelfType selfType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            selfType = new SelfType.Reference(false);
        }
        this(rsFunction, selfType);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.elementName};
        return RsBundle.INSTANCE.message("intention.family.name.add.self.to", objectArray);
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.elementName};
        return RsBundle.INSTANCE.message("intention.family.name.add.self.to", objectArray);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsFunction element) {
        block2: {
            PsiElement parent2;
            RsValueParameterList valueParameterList;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            boolean hasParameters = !((Collection)RsFunctionKt.getRawValueParameters(element)).isEmpty();
            RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
            RsValueParameterList rsValueParameterList = valueParameterList = element.getValueParameterList();
            PsiElement lparen = rsValueParameterList != null ? rsValueParameterList.getFirstChild() : null;
            RsSelfParameter self = this.selfType.createSelfPsiElement(psiFactory);
            RsValueParameterList rsValueParameterList2 = valueParameterList;
            if (rsValueParameterList2 != null) {
                rsValueParameterList2.addAfter(self, lparen);
            }
            if (!hasParameters) break block2;
            PsiElement psiElement2 = lparen;
            PsiElement psiElement3 = parent2 = psiElement2 != null ? psiElement2.getParent() : null;
            if (psiElement3 != null) {
                psiElement3.addAfter(psiFactory.createComma(), parent2.getFirstChild().getNextSibling());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b2\u00020\u0001:\u0004\b\t\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/fixes/AddSelfFix$SelfType;", "", "<init>", "()V", "createSelfPsiElement", "Lorg/rust/lang/core/psi/RsSelfParameter;", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "Pure", "Reference", "Adt", "Companion", "Lorg/rust/ide/fixes/AddSelfFix$SelfType$Adt;", "Lorg/rust/ide/fixes/AddSelfFix$SelfType$Pure;", "Lorg/rust/ide/fixes/AddSelfFix$SelfType$Reference;", "intellij.rustrover.core"})
    public static abstract sealed class SelfType {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private SelfType() {
        }

        @NotNull
        public abstract RsSelfParameter createSelfPsiElement(@NotNull RsPsiFactory var1);

        public /* synthetic */ SelfType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/rust/ide/fixes/AddSelfFix$SelfType$Adt;", "Lorg/rust/ide/fixes/AddSelfFix$SelfType;", "typeText", "", "<init>", "(Ljava/lang/String;)V", "createSelfPsiElement", "Lorg/rust/lang/core/psi/RsSelfParameter;", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "intellij.rustrover.core"})
        public static final class Adt
        extends SelfType {
            @NotNull
            private final String typeText;

            public Adt(@NotNull String typeText) {
                Intrinsics.checkNotNullParameter((Object)typeText, (String)"typeText");
                super(null);
                this.typeText = typeText;
            }

            @Override
            @NotNull
            public RsSelfParameter createSelfPsiElement(@NotNull RsPsiFactory psiFactory) {
                Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
                return RsPsiFactory.createSelfWithType$default(psiFactory, this.typeText, false, 2, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/fixes/AddSelfFix$SelfType$Companion;", "", "<init>", "()V", "fromSelf", "Lorg/rust/ide/fixes/AddSelfFix$SelfType;", "self", "Lorg/rust/lang/core/psi/RsSelfParameter;", "intellij.rustrover.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SelfType fromSelf(@NotNull RsSelfParameter self) {
                SelfType selfType;
                Intrinsics.checkNotNullParameter((Object)self, (String)"self");
                RsTypeReference selfType2 = self.getTypeReference();
                if (selfType2 != null) {
                    String string = selfType2.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    selfType = new Adt(string);
                } else {
                    selfType = RsSelfParameterKt.isRef(self) ? (SelfType)new Reference(RsSelfParameterKt.getMutability(self).isMut()) : (SelfType)new Pure(RsSelfParameterKt.getMutability(self).isMut());
                }
                return selfType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/rust/ide/fixes/AddSelfFix$SelfType$Pure;", "Lorg/rust/ide/fixes/AddSelfFix$SelfType;", "mutable", "", "<init>", "(Z)V", "createSelfPsiElement", "Lorg/rust/lang/core/psi/RsSelfParameter;", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "intellij.rustrover.core"})
        public static final class Pure
        extends SelfType {
            private final boolean mutable;

            public Pure(boolean mutable) {
                super(null);
                this.mutable = mutable;
            }

            @Override
            @NotNull
            public RsSelfParameter createSelfPsiElement(@NotNull RsPsiFactory psiFactory) {
                Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
                return psiFactory.createSelf(this.mutable);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/rust/ide/fixes/AddSelfFix$SelfType$Reference;", "Lorg/rust/ide/fixes/AddSelfFix$SelfType;", "mutable", "", "<init>", "(Z)V", "createSelfPsiElement", "Lorg/rust/lang/core/psi/RsSelfParameter;", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "intellij.rustrover.core"})
        public static final class Reference
        extends SelfType {
            private final boolean mutable;

            public Reference(boolean mutable) {
                super(null);
                this.mutable = mutable;
            }

            @Override
            @NotNull
            public RsSelfParameter createSelfPsiElement(@NotNull RsPsiFactory psiFactory) {
                Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
                return psiFactory.createSelfReference(this.mutable);
            }
        }
    }
}

