/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.ClapDeriveAddRequiredDependencyFeaturesFix;
import org.rust.ide.fixes.GenericAddRequiredDependencyFeaturesFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.fixes.SerdeDeriveAddRequiredDependencyFeaturesFix;
import org.rust.ide.fixes.TokioMainAddRequiredDependencyFeaturesFix;
import org.rust.ide.utils.FeatureInfo;
import org.rust.lang.core.RsPsiPattern;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.lang.core.psi.ext.RsOuterAttributeOwner;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.lang.core.psi.ext.RsVisible;
import org.rust.openapiext.UtilsKt;
import org.rust.toml.CrateExtKt;
import org.rust.toml.UtilKt;
import org.rust.toml.psi.CargoFile;
import org.rust.toml.psi.CargoFileKt;
import org.rust.toml.psi.CargoTomlDependencyType;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/fixes/AddRequiredDependencyFeaturesFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/toml/lang/psi/TomlFile;", "element", "dependencyName", "", "requiredFeatures", "", "<init>", "(Lorg/toml/lang/psi/TomlFile;Ljava/lang/String;Ljava/util/List;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nAddRequiredDependencyFeaturesFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddRequiredDependencyFeaturesFix.kt\norg/rust/ide/fixes/AddRequiredDependencyFeaturesFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public abstract class AddRequiredDependencyFeaturesFix
extends RsQuickFixBase<TomlFile> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final String dependencyName;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final List<String> requiredFeatures;
    @NotNull
    private static final Map<String, String> DERIVE_TO_DEPENDENCY;

    public AddRequiredDependencyFeaturesFix(@NotNull TomlFile element, @NotNull String dependencyName, @NotNull List<String> requiredFeatures) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkNotNullParameter(requiredFeatures, (String)"requiredFeatures");
        super((PsiElement)element);
        this.dependencyName = dependencyName;
        this.requiredFeatures = requiredFeatures;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.name.add.required.features.family.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.dependencyName};
        return RsBundle.INSTANCE.message("intention.name.add.required.features", objectArray);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull TomlFile element) {
        block2: {
            CargoFile cargoFile;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            CargoFile cargoFile2 = CargoFileKt.toCargoFile$default(element, null, 1, null);
            if (cargoFile2 == null) break block2;
            CargoFile $this$invoke_u24lambda_u240 = cargoFile = cargoFile2;
            boolean bl = false;
            $this$invoke_u24lambda_u240.addCrateToDependency(this.dependencyName, this.requiredFeatures, CargoTomlDependencyType.NORMAL, "1.0.0");
            if (!PsiElementKt.isIntentionPreviewElement((PsiElement)element)) {
                Document document = UtilsKt.getDocument((PsiFile)element);
                if (document != null) {
                    Document it2 = document;
                    boolean bl2 = false;
                    FileDocumentManager.getInstance().saveDocument(it2);
                }
                UtilsKt.refresh(project);
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Args", (Object)"clap"), TuplesKt.to((Object)"clap::Args", (Object)"clap"), TuplesKt.to((Object)"Subcommand", (Object)"clap"), TuplesKt.to((Object)"clap::Subcommand", (Object)"clap"), TuplesKt.to((Object)"Parser", (Object)"clap"), TuplesKt.to((Object)"clap::Parser", (Object)"clap"), TuplesKt.to((Object)"Serialize", (Object)"serde"), TuplesKt.to((Object)"serde::Serialize", (Object)"serde"), TuplesKt.to((Object)"Deserialize", (Object)"serde"), TuplesKt.to((Object)"serde::Deserialize", (Object)"serde")};
        DERIVE_TO_DEPENDENCY = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/fixes/AddRequiredDependencyFeaturesFix$Companion;", "", "<init>", "()V", "createIfCompatible", "", "Lorg/rust/ide/fixes/AddRequiredDependencyFeaturesFix;", "element", "Lorg/rust/lang/core/psi/ext/RsReferenceElement;", "createFixForTokioMain", "createFixForDerive", "DERIVE_TO_DEPENDENCY", "", "", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nAddRequiredDependencyFeaturesFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddRequiredDependencyFeaturesFix.kt\norg/rust/ide/fixes/AddRequiredDependencyFeaturesFix$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1#2:120\n1#2:146\n1#2:159\n1563#3:121\n1634#3,3:122\n808#3,11:125\n1617#3,9:136\n1869#3:145\n1870#3:147\n1626#3:148\n1669#3,8:149\n1625#3:157\n1869#3:158\n1870#3:160\n1626#3:161\n*S KotlinDebug\n*F\n+ 1 AddRequiredDependencyFeaturesFix.kt\norg/rust/ide/fixes/AddRequiredDependencyFeaturesFix$Companion\n*L\n61#1:146\n63#1:159\n58#1:121\n58#1:122,3\n60#1:125,11\n61#1:136,9\n61#1:145\n61#1:147\n61#1:148\n62#1:149,8\n63#1:157\n63#1:158\n63#1:160\n63#1:161\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<AddRequiredDependencyFeaturesFix> createIfCompatible(@NotNull RsReferenceElement element) {
            void $this$mapNotNullTo$iv;
            Iterable $this$distinctBy$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            List list;
            List list2;
            Iterable $this$map$iv;
            Object it2;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            List fixes = new ArrayList();
            AddRequiredDependencyFeaturesFix addRequiredDependencyFeaturesFix = this.createFixForTokioMain(element);
            if (addRequiredDependencyFeaturesFix != null) {
                it2 = addRequiredDependencyFeaturesFix;
                boolean bl = false;
                ((Collection)fixes).add(it2);
            }
            AddRequiredDependencyFeaturesFix addRequiredDependencyFeaturesFix2 = this.createFixForDerive(element);
            if (addRequiredDependencyFeaturesFix2 != null) {
                it2 = addRequiredDependencyFeaturesFix2;
                boolean bl = false;
                ((Collection)fixes).add(it2);
            }
            TomlFile tomlFile = CrateExtKt.getTomlFile(RsElementKt.getContainingCrate(element));
            if (tomlFile == null) {
                return fixes;
            }
            TomlFile cargoToml = tomlFile;
            Object object = element.getReference();
            if (object != null && (object = object.multiResolve()) != null) {
                void $this$mapTo$iv$iv;
                $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    RsElement rsElement = (RsElement)item$iv$iv;
                    Object object2 = destination$iv$iv;
                    boolean bl = false;
                    RsVisible rsVisible = it3 instanceof RsFile ? (RsFile)it3 : null;
                    object2.add(rsVisible != null && (rsVisible = rsVisible.getDeclaration()) != null ? (RsElement)rsVisible : it3);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            List resolved = list;
            it2 = resolved;
            boolean $i$f$filterIsInstance = false;
            $this$map$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof RsOuterAttributeOwner)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FeatureInfo it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                RsOuterAttributeOwner it4 = (RsOuterAttributeOwner)element$iv$iv;
                boolean bl2 = false;
                if (FeatureInfo.Companion.createIfCompatible(it4) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<Pair> set$iv = new HashSet<Pair>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                FeatureInfo it5 = (FeatureInfo)e$iv;
                boolean bl = false;
                Pair key$iv = TuplesKt.to((Object)it5.getDependencyName(), it5.getRequiredFeatures());
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            Collection destination$iv = fixes;
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv.iterator();
            while (iterator3.hasNext()) {
                GenericAddRequiredDependencyFeaturesFix it$iv;
                List<String> dependencyFeatures;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator3.next();
                boolean bl = false;
                FeatureInfo info = (FeatureInfo)element$iv;
                boolean bl4 = false;
                if ((PsiElementKt.isIntentionPreviewElement(info.getElement()) ? null : (UtilKt.findDependencyElement(cargoToml, info.getDependencyName()) == null ? null : ((dependencyFeatures = UtilKt.findDependencyFeatures(cargoToml, info.getDependencyName())).containsAll((Collection)info.getRequiredFeatures()) ? null : new GenericAddRequiredDependencyFeaturesFix(cargoToml, info.getDependencyName(), info.getRequiredFeatures())))) == null) continue;
                it$iv = it$iv;
                boolean bl5 = false;
                destination$iv.add(it$iv);
            }
            return fixes;
        }

        @Nullable
        public final AddRequiredDependencyFeaturesFix createFixForTokioMain(@NotNull RsReferenceElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!Intrinsics.areEqual((Object)element.getText(), (Object)"tokio::main")) {
                return null;
            }
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof RsMetaItem)) {
                return null;
            }
            if (!(RsMetaItemKt.getOwner((RsMetaItem)parent2) instanceof RsFunction)) {
                return null;
            }
            TomlFile tomlFile = CrateExtKt.getTomlFile(RsElementKt.getContainingCrate(element));
            if (tomlFile == null) {
                return null;
            }
            TomlFile cargoToml = tomlFile;
            if (UtilKt.findDependencyElement(cargoToml, "tokio") == null) {
                return null;
            }
            List<String> tokioFeatures = UtilKt.findDependencyFeatures(cargoToml, "tokio");
            if (tokioFeatures.contains("full") || tokioFeatures.contains("macros") && (tokioFeatures.contains("rt") || tokioFeatures.contains("rt-multi-thread"))) {
                return null;
            }
            return new TokioMainAddRequiredDependencyFeaturesFix(cargoToml);
        }

        private final AddRequiredDependencyFeaturesFix createFixForDerive(RsReferenceElement element) {
            AddRequiredDependencyFeaturesFix addRequiredDependencyFeaturesFix;
            String string = (String)DERIVE_TO_DEPENDENCY.get(element.getText());
            if (string == null) {
                return null;
            }
            String dependencyName = string;
            if (!RsPsiPattern.INSTANCE.getDerivedTraitMetaItem().accepts((Object)element.getParent())) {
                return null;
            }
            TomlFile tomlFile = CrateExtKt.getTomlFile(RsElementKt.getContainingCrate(element));
            if (tomlFile == null) {
                return null;
            }
            TomlFile cargoToml = tomlFile;
            if (UtilKt.findDependencyElement(cargoToml, dependencyName) == null) {
                return null;
            }
            List<String> features = UtilKt.findDependencyFeatures(cargoToml, dependencyName);
            if (features.contains("derive")) {
                return null;
            }
            String string2 = dependencyName;
            if (Intrinsics.areEqual((Object)string2, (Object)"clap")) {
                addRequiredDependencyFeaturesFix = new ClapDeriveAddRequiredDependencyFeaturesFix(cargoToml);
            } else if (Intrinsics.areEqual((Object)string2, (Object)"serde")) {
                addRequiredDependencyFeaturesFix = new SerdeDeriveAddRequiredDependencyFeaturesFix(cargoToml);
            } else {
                throw new IllegalStateException("unreachable".toString());
            }
            return addRequiredDependencyFeaturesFix;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

