/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.AddModuleFileFixKt;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.refactoring.RsPromoteModuleToDirectoryAction;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsModDeclItem;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.resolve.RsModFileResolutionAnchor;
import org.rust.lang.core.resolve.RsModFileResolutionAnchorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u000b*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/rust/ide/fixes/AddModuleFileFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsModDeclItem;", "modDecl", "expandModuleFirst", "", "location", "Lorg/rust/ide/fixes/AddModuleFileFix$Location;", "<init>", "(Lorg/rust/lang/core/psi/RsModDeclItem;ZLorg/rust/ide/fixes/AddModuleFileFix$Location;)V", "text", "", "getText", "getFamilyName", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "path", "getPath", "(Lorg/rust/lang/core/psi/RsModDeclItem;)Ljava/lang/String;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Location", "Companion", "intellij.rustrover.core"})
public final class AddModuleFileFix
extends RsQuickFixBase<RsModDeclItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean expandModuleFirst;
    @NotNull
    private final Location location;
    @IntentionName
    @NotNull
    private final String text;

    public AddModuleFileFix(@NotNull RsModDeclItem modDecl, boolean expandModuleFirst, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)modDecl, (String)"modDecl");
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        super((PsiElement)modDecl);
        this.expandModuleFirst = expandModuleFirst;
        this.location = location;
        Object[] objectArray = new Object[]{this.getPath(modDecl)};
        this.text = RsBundle.INSTANCE.message("intention.name.create.module.file", objectArray);
    }

    public /* synthetic */ AddModuleFileFix(RsModDeclItem rsModDeclItem, boolean bl, Location location, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            location = Location.File;
        }
        this(rsModDeclItem, bl, location);
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.create.module.file", new Object[0]);
    }

    @Override
    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return null;
    }

    private final String getPath(RsModDeclItem $this$path) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.location.ordinal()]) {
            case 1 -> $this$path.getName() + ".rs";
            case 2 -> $this$path.getName() + "/mod.rs";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsModDeclItem element) {
        PsiFile existing;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.expandModuleFirst) {
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsFile");
            RsFile containingFile = (RsFile)psiFile;
            RsPromoteModuleToDirectoryAction.Companion.expandModule(containingFile);
        }
        RsElement rsElement = element.getReference().resolve();
        Object object = existing = rsElement != null ? rsElement.getContainingFile() : null;
        if (existing != null) {
            existing.navigate(true);
            return;
        }
        RsModFileResolutionAnchor rsModFileResolutionAnchor = RsModFileResolutionAnchorKt.getModFileResolutionAnchor$default(element, false, 1, null);
        if (rsModFileResolutionAnchor == null || (rsModFileResolutionAnchor = rsModFileResolutionAnchor.getOwnedDirectory(true)) == null) {
            return;
        }
        RsModFileResolutionAnchor dir = rsModFileResolutionAnchor;
        Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[this.location.ordinal()]) {
            case 1 -> TuplesKt.to((Object)dir, (Object)(element.getName() + ".rs"));
            case 2 -> TuplesKt.to((Object)AddModuleFileFixKt.access$getOrCreateSubdirectory((PsiDirectory)dir, String.valueOf(element.getName())), (Object)"mod.rs");
            default -> throw new NoWhenBranchMatchedException();
        };
        PsiDirectory dstDir = (PsiDirectory)pair.component1();
        String fileName = (String)pair.component2();
        PsiFile psiFile = dstDir.findFile(fileName);
        if (psiFile == null) {
            psiFile = dstDir.createFile(fileName);
        }
        psiFile.navigate(true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/fixes/AddModuleFileFix$Companion;", "", "<init>", "()V", "createFixes", "", "Lorg/rust/ide/fixes/AddModuleFileFix;", "modDecl", "Lorg/rust/lang/core/psi/RsModDeclItem;", "expandModuleFirst", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<AddModuleFileFix> createFixes(@NotNull RsModDeclItem modDecl, boolean expandModuleFirst) {
            Intrinsics.checkNotNullParameter((Object)modDecl, (String)"modDecl");
            AddModuleFileFix[] addModuleFileFixArray = new AddModuleFileFix[]{new AddModuleFileFix(modDecl, expandModuleFirst, Location.File), new AddModuleFileFix(modDecl, expandModuleFirst, Location.Directory)};
            return CollectionsKt.listOf((Object[])addModuleFileFixArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/fixes/AddModuleFileFix$Location;", "", "<init>", "(Ljava/lang/String;I)V", "File", "Directory", "intellij.rustrover.core"})
    public static final class Location
    extends Enum<Location> {
        public static final /* enum */ Location File = new Location();
        public static final /* enum */ Location Directory = new Location();
        private static final /* synthetic */ Location[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Location[] values() {
            return (Location[])$VALUES.clone();
        }

        public static Location valueOf(String value) {
            return Enum.valueOf(Location.class, value);
        }

        @NotNull
        public static EnumEntries<Location> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = locationArray = new Location[]{Location.File, Location.Directory};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Location.values().length];
            try {
                nArray[Location.File.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Location.Directory.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

