/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.AddMissingSupertraitImplFixKt;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.resolve.ref.RsPathReferenceImplKt;
import org.rust.lang.core.types.BoundElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.RsPsiSubstitution;
import org.rust.lang.core.types.TraitRef;
import org.rust.lang.core.types.ty.Ty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/fixes/AddMissingSupertraitImplFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsImplItem;", "implItem", "<init>", "(Lorg/rust/lang/core/psi/RsImplItem;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
public final class AddMissingSupertraitImplFix
extends RsQuickFixBase<RsImplItem> {
    public AddMissingSupertraitImplFix(@NotNull RsImplItem implItem) {
        Intrinsics.checkNotNullParameter((Object)implItem, (String)"implItem");
        super((PsiElement)implItem);
    }

    @Override
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.implement.missing.supertrait.s", new Object[0]);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsImplItem element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsTraitRef rsTraitRef = element.getTraitRef();
        if (rsTraitRef == null) {
            return;
        }
        RsTraitRef traitRef = rsTraitRef;
        BoundElement<RsTraitItem> boundElement = element.getImplementedTrait();
        if (boundElement == null) {
            return;
        }
        BoundElement<RsTraitItem> trait = boundElement;
        RsTypeReference rsTypeReference = element.getTypeReference();
        if (rsTypeReference == null) {
            return;
        }
        RsTypeReference typeRef = rsTypeReference;
        ImplLookup implLookup = ExtensionsKt.getImplLookup(element);
        Ty type = ExtensionsKt.normType(typeRef, implLookup);
        List traits = new ArrayList();
        RsPsiSubstitution[] rsPsiSubstitutionArray = new RsPsiSubstitution[1];
        RsPath rsPath = traitRef.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)rsPath, (String)"getPath(...)");
        rsPsiSubstitutionArray[0] = RsPathReferenceImplKt.getPsiSubstitution$default(rsPath, (RsGenericDeclaration)trait.getElement(), null, 4, null);
        List substitutions = CollectionsKt.mutableListOf((Object[])rsPsiSubstitutionArray);
        AddMissingSupertraitImplFixKt.access$collectSuperTraits(trait, traitRef, substitutions, traits, new LinkedHashSet());
        for (Pair pair : traits) {
            BoundElement superTrait = (BoundElement)pair.component1();
            RsTraitRef ref = (RsTraitRef)pair.component2();
            if (Intrinsics.areEqual((Object)superTrait, trait) || ImplLookup.canSelect$default(implLookup, new TraitRef(type, superTrait), 0, 2, null)) continue;
            AddMissingSupertraitImplFixKt.access$implementTrait(element, ref, typeRef, trait, substitutions, editor2);
        }
    }
}

