/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014 \n*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/fixes/AddMethodCallFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsExpr;", "expr", "method", "", "<init>", "(Lorg/rust/lang/core/psi/RsExpr;Ljava/lang/String;)V", "exprText", "Lcom/intellij/openapi/util/NlsSafe;", "kotlin.jvm.PlatformType", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "intellij.rustrover.core"})
public abstract class AddMethodCallFix
extends RsQuickFixBase<RsExpr> {
    @NotNull
    private final String method;
    private final String exprText;

    public AddMethodCallFix(@NotNull RsExpr expr, @NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        super((PsiElement)expr);
        this.method = method;
        this.exprText = expr.getText();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.add.method.call", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.method;
        Intrinsics.checkNotNullExpressionValue((Object)this.exprText, (String)"exprText");
        return RsBundle.INSTANCE.message("intention.name.add.method.call", objectArray);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsExpr element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsPsiFactory rsPsiFactory = new RsPsiFactory(project, false, false, 6, null);
        String string = this.exprText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exprText");
        element.replace(rsPsiFactory.createMethodCall(string, this.method));
    }
}

