/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsLitExprKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\r\u001a\u00070\f\u00a2\u0006\u0002\b\u000eH\u0016J\r\u0010\u000f\u001a\u00070\f\u00a2\u0006\u0002\b\u000eH\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/fixes/AddFormatParameterFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsLitExpr;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "arg", "debug", "", "priority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "<init>", "(Lorg/rust/lang/core/psi/RsLitExpr;ZLcom/intellij/codeInsight/intention/PriorityAction$Priority;)V", "parameter", "", "getFamilyName", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "getPriority", "intellij.rustrover.core"})
public final class AddFormatParameterFix
extends RsQuickFixBase<RsLitExpr>
implements PriorityAction {
    @NotNull
    private final PriorityAction.Priority priority;
    @NlsSafe
    @NotNull
    private final String parameter;

    public AddFormatParameterFix(@NotNull RsLitExpr arg, boolean debug, @NotNull PriorityAction.Priority priority) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        super((PsiElement)arg);
        this.priority = priority;
        this.parameter = debug ? "{:?}" : "{}";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.parameter};
        return RsBundle.INSTANCE.getMessage("intention.name.add.format.argument", objectArray);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsLitExpr element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = RsLitExprKt.getStringValue(element);
        if (string == null) {
            return;
        }
        String value = string;
        Character c = StringsKt.lastOrNull((CharSequence)value);
        boolean endsWithWhitespace = c != null ? CharsKt.isWhitespace((char)c.charValue()) : true;
        String targetString = endsWithWhitespace ? value + this.parameter : value + " " + this.parameter;
        RsLitExpr newString = new RsPsiFactory(project, false, false, 6, null).createLitExpr(targetString);
        element.replace(newString);
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return this.priority;
    }
}

