/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.utils.template.EditorExtKt;
import org.rust.lang.core.psi.PsiModificationUtilsKt;
import org.rust.lang.core.psi.RsBlockFields;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsNamedFieldDecl;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsFieldsOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f0\u0005\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/rust/ide/fixes/AddFieldToStructTypeFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/ext/RsFieldsOwner;", "owner", "fieldName", "", "needsPub", "", "<init>", "(Lorg/rust/lang/core/psi/ext/RsFieldsOwner;Ljava/lang/String;Z)V", "typeName", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/util/NlsSafe;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nAddFieldToStructTypeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddFieldToStructTypeFix.kt\norg/rust/ide/fixes/AddFieldToStructTypeFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,65:1\n1#2:66\n121#3:67\n*S KotlinDebug\n*F\n+ 1 AddFieldToStructTypeFix.kt\norg/rust/ide/fixes/AddFieldToStructTypeFix\n*L\n49#1:67\n*E\n"})
public final class AddFieldToStructTypeFix
extends RsQuickFixBase<RsFieldsOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fieldName;
    private final boolean needsPub;
    @NotNull
    private final String typeName;

    private AddFieldToStructTypeFix(RsFieldsOwner owner, String fieldName, boolean needsPub) {
        super((PsiElement)owner);
        this.fieldName = fieldName;
        this.needsPub = needsPub;
        String string = owner.getName();
        if (string == null) {
            string = "";
        }
        this.typeName = string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.fieldName, this.typeName};
        return RsBundle.INSTANCE.message("intention.name.add.field.to.struct", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsFieldsOwner element) {
        void $this$descendantOfTypeStrict$iv;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor2 == null) {
            return;
        }
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
        RsBlockFields blockFields = element.getBlockFields();
        String fieldText = (this.needsPub ? "pub " : "") + this.fieldName + ": ()";
        if (blockFields == null) {
            PsiElement lastChild = element.getLastChild();
            RsBlockFields block = factory2.createBlockFieldsWithField(fieldText);
            Intrinsics.checkNotNull((Object)lastChild);
            if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(lastChild), (Object)RsElementTypes.SEMICOLON)) {
                PsiElement psiElement3;
                PsiElement it2 = psiElement3 = element.addBefore(block, lastChild);
                boolean bl = false;
                lastChild.delete();
                psiElement2 = psiElement3;
            } else {
                psiElement2 = element.add(block);
            }
        } else {
            List<RsNamedFieldDecl> list = blockFields.getNamedFieldDeclList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getNamedFieldDeclList(...)");
            PsiModificationUtilsKt.ensureTrailingComma(list);
            psiElement2 = blockFields.addBefore(factory2.createStructNamedField(fieldText), blockFields.getRbrace());
        }
        PsiElement psiElement4 = psiElement2;
        Intrinsics.checkNotNull((Object)psiElement4);
        boolean $i$f$descendantOfTypeStrict = false;
        RsTypeReference type = (RsTypeReference)PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeStrict$iv, RsTypeReference.class, (boolean)true);
        if (type == null) {
            return;
        }
        EditorExtKt.newTemplateBuilder$default(editor2, element, false, 2, null).replaceElement((PsiElement)type, "()").runInline();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public /* synthetic */ AddFieldToStructTypeFix(RsFieldsOwner owner, String fieldName, boolean needsPub, DefaultConstructorMarker $constructor_marker) {
        this(owner, fieldName, needsPub);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/ide/fixes/AddFieldToStructTypeFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/AddFieldToStructTypeFix;", "owner", "Lorg/rust/lang/core/psi/ext/RsFieldsOwner;", "fieldName", "", "needsPub", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AddFieldToStructTypeFix createIfCompatible(@NotNull RsFieldsOwner owner, @NotNull String fieldName, boolean needsPub) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            if (owner.getTupleFields() != null) {
                return null;
            }
            if (RsElementKt.getContainingCrate(owner).getOrigin() != PackageOrigin.WORKSPACE) {
                return null;
            }
            return new AddFieldToStructTypeFix(owner, fieldName, needsPub, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

