/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.AddCrateDependencyFixKt;
import org.rust.ide.fixes.ImportItemFromCrateFixKt;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.ide.typing.paste.RsPopularCratesCopyPasteProcessorKt;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;
import org.rust.stdext.RsResultKt;
import org.rust.toml.CrateExtKt;
import org.rust.toml.crates.local.CargoRegistryCrate;
import org.rust.toml.crates.local.CargoRegistryCrateVersion;
import org.rust.toml.crates.local.CratesLocalIndexService;
import org.rust.toml.psi.CargoFile;
import org.rust.toml.psi.CargoFileKt;
import org.rust.toml.psi.CargoTomlDependencyType;
import org.rust.toml.psi.PropertiesManipulatorsKt;
import org.rust.util.RsPopularItemsKt;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/fixes/AddCrateDependencyFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/toml/lang/psi/TomlFile;", "element", "containingCrate", "Lorg/rust/lang/core/crate/Crate;", "crateToImport", "", "features", "", "dependencyType", "Lorg/rust/toml/psi/CargoTomlDependencyType;", "<init>", "(Lorg/toml/lang/psi/TomlFile;Lorg/rust/lang/core/crate/Crate;Ljava/lang/String;Ljava/util/List;Lorg/rust/toml/psi/CargoTomlDependencyType;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nAddCrateDependencyFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddCrateDependencyFix.kt\norg/rust/ide/fixes/AddCrateDependencyFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class AddCrateDependencyFix
extends RsQuickFixBase<TomlFile> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Crate containingCrate;
    @NotNull
    private final String crateToImport;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final List<String> features;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final CargoTomlDependencyType dependencyType;

    public AddCrateDependencyFix(@NotNull TomlFile element, @NotNull Crate containingCrate, @NotNull String crateToImport, @NotNull List<String> features, @NotNull CargoTomlDependencyType dependencyType) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)containingCrate, (String)"containingCrate");
        Intrinsics.checkNotNullParameter((Object)crateToImport, (String)"crateToImport");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        super((PsiElement)element);
        this.containingCrate = containingCrate;
        this.crateToImport = crateToImport;
        this.features = features;
        this.dependencyType = dependencyType;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.add.to.dependencies", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.crateToImport, this.dependencyType.getKeyword()};
        return RsBundle.INSTANCE.message("intention.name.add.to.dependencies", objectArray);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull TomlFile element) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!PsiElementKt.isIntentionPreviewElement((PsiElement)element)) {
                RsCounterUsagesCollector.INSTANCE.logAddCrateDependency(project, this.crateToImport, !((Collection)this.features).isEmpty());
            }
            CargoFile cargoFile = CargoFileKt.toCargoFile(element, this.containingCrate);
            if (cargoFile == null) break block4;
            CargoFile it2 = cargoFile;
            boolean bl = false;
            RsResult result2 = CargoFile.addCrateToDependency$default(it2, this.crateToImport, this.features, this.dependencyType, null, 8, null);
            if (!PsiElementKt.isIntentionPreviewElement((PsiElement)element)) {
                Editor editor3 = editor2;
                if (editor3 != null) {
                    Editor it3 = editor3;
                    boolean bl2 = false;
                    RsResultKt.showHintOnError(result2, it3);
                }
                Document document = UtilsKt.getDocument((PsiFile)element);
                if (document != null) {
                    Document it4 = document;
                    boolean bl3 = false;
                    FileDocumentManager.getInstance().saveDocument(it4);
                }
                UtilsKt.refresh(project);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/fixes/AddCrateDependencyFix$Companion;", "", "<init>", "()V", "createIfCompatible", "Lorg/rust/ide/fixes/AddCrateDependencyFix;", "path", "Lorg/rust/lang/core/psi/ext/RsReferenceElement;", "shouldAddFixForCrate", "", "crateName", "", "isDeadDependency", "crate", "Lorg/rust/toml/crates/local/CargoRegistryCrate;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nAddCrateDependencyFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddCrateDependencyFix.kt\norg/rust/ide/fixes/AddCrateDependencyFix$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RsResult.kt\norg/rust/stdext/RsResultKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n60#3,4:109\n1740#4,3:113\n*S KotlinDebug\n*F\n+ 1 AddCrateDependencyFix.kt\norg/rust/ide/fixes/AddCrateDependencyFix$Companion\n*L\n88#1:109,4\n99#1:113,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final AddCrateDependencyFix createIfCompatible(@NotNull RsReferenceElement path) {
            String string;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            boolean onlyPopularCrates = Registry.Companion.is("org.rust.ide.fixes.use.popular.crates.in.add.dependency", false);
            if (onlyPopularCrates) {
                string = RsPopularCratesCopyPasteProcessorKt.getPopularCrate(path);
            } else {
                String string2;
                String string3 = path.getReferenceName();
                String string4 = string3;
                if (string3 == null) return null;
                String it2 = string2 = string4;
                boolean bl = false;
                if (!Companion.shouldAddFixForCrate(it2)) return null;
                String string5 = string2;
                string4 = string5;
                if (string5 == null) return null;
                string = StringsKt.replace$default((String)string4, (String)"_", (String)"-", (boolean)false, (int)4, null);
            }
            if (string == null) {
                return null;
            }
            String crateName = string;
            if (!onlyPopularCrates) {
                CargoRegistryCrate cargoRegistryCrate;
                CargoRegistryCrate cargoRegistryCrate2 = CratesLocalIndexService.Companion.getInstance().getCrate(crateName).ok();
                if (cargoRegistryCrate2 == null) return null;
                CargoRegistryCrate it3 = cargoRegistryCrate = cargoRegistryCrate2;
                boolean bl = false;
                if (Companion.isDeadDependency(it3)) return null;
                boolean bl2 = true;
                if (!bl2) return null;
                CargoRegistryCrate cargoRegistryCrate3 = cargoRegistryCrate;
                CargoRegistryCrate cargoRegistryCrate4 = cargoRegistryCrate3;
                if (cargoRegistryCrate4 == null) {
                    return null;
                }
            }
            Crate containingCrate = RsElementKt.getContainingCrate(path);
            TomlFile tomlFile = CrateExtKt.getTomlFile(containingCrate);
            if (tomlFile == null) {
                return null;
            }
            TomlFile tomlFile2 = tomlFile;
            PsiFile bl = path.getContainingFile();
            RsFile rsFile = bl instanceof RsFile ? (RsFile)bl : null;
            CargoTomlDependencyType dependencyType = (rsFile != null ? RsFileKt.isBuildScript(rsFile) : false) ? CargoTomlDependencyType.BUILD : CargoTomlDependencyType.NORMAL;
            String[] $this$unwrapOrElse$iv = ImportItemFromCrateFixKt.getDependencyVersion(containingCrate, crateName);
            boolean $i$f$unwrapOrElse = false;
            String[] stringArray = $this$unwrapOrElse$iv;
            if (!(stringArray instanceof RsResult.Ok)) {
                if (!(stringArray instanceof RsResult.Err)) throw new NoWhenBranchMatchedException();
                String it4 = (String)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                return null;
            }
            if (((RsResult.Ok)$this$unwrapOrElse$iv).getOk() == null) {
                return null;
            }
            $this$unwrapOrElse$iv = new String[]{"dependencies", crateName};
            if (PropertiesManipulatorsKt.findPropertyValue(tomlFile2, $this$unwrapOrElse$iv) != null) {
                return null;
            }
            Object object = path instanceof RsPath ? (RsPath)path : null;
            if (object == null || (object = RsPopularItemsKt.popularItemsFeatures((RsPath)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            Object features = object;
            return new AddCrateDependencyFix(tomlFile2, containingCrate, crateName, (List<String>)features, dependencyType);
        }

        private final boolean shouldAddFixForCrate(String crateName) {
            return crateName.length() > 1 && !AddCrateDependencyFixKt.access$getCRATE_NAMES_NOT_FOR_IMPORT$p().contains(crateName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isDeadDependency(CargoRegistryCrate crate) {
            CargoRegistryCrateVersion it2;
            if (crate.getVersions().size() < 2) return true;
            Iterable $this$all$iv = crate.getVersions();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                it2 = (CargoRegistryCrateVersion)element$iv;
                boolean bl = false;
            } while (it2.isYanked());
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

