/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsMetaItemArgs;
import org.rust.lang.core.psi.RsPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/fixes/AddAttrParenthesesFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsMetaItem;", "element", "attrName", "", "<init>", "(Lorg/rust/lang/core/psi/RsMetaItem;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
public final class AddAttrParenthesesFix
extends RsQuickFixBase<RsMetaItem> {
    @NotNull
    private final String attrName;

    public AddAttrParenthesesFix(@NotNull RsMetaItem element, @NotNull String attrName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        super((PsiElement)element);
        this.attrName = attrName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.add.parentheses", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.attrName};
        return RsBundle.INSTANCE.message("intention.name.add.parentheses.to", objectArray);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsMetaItem element) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsMetaItem rsMetaItem = new RsPsiFactory(project, false, false, 6, null).createOuterAttr(this.attrName + "()").getMetaItem();
            Intrinsics.checkNotNullExpressionValue((Object)rsMetaItem, (String)"<get-metaItem>(...)");
            RsMetaItem newItem = rsMetaItem;
            PsiElement psiElement2 = element.replace(newItem);
            RsMetaItem rsMetaItem2 = psiElement2 instanceof RsMetaItem ? (RsMetaItem)psiElement2 : null;
            if (rsMetaItem2 == null) {
                return;
            }
            RsMetaItem replaced = rsMetaItem2;
            RsMetaItemArgs rsMetaItemArgs = replaced.getMetaItemArgs();
            if (rsMetaItemArgs == null || (rsMetaItemArgs = rsMetaItemArgs.getLparen()) == null) {
                return;
            }
            int offset = rsMetaItemArgs.getTextOffset();
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block2;
            editor3.moveToOffset(offset + 1);
        }
    }
}

