/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.dialog.CommonBlockBasedFeedbackDialogWithEmail;
import com.intellij.platform.feedback.dialog.uiBlocks.DescriptionBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TextAreaBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TopLabelBlock;
import com.intellij.platform.feedback.impl.notification.ThanksForFeedbackNotification;
import java.util.List;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.feedback.RsComboBoxBlock;
import org.rust.ide.feedback.RsFeedbackPersistenceState;
import org.rust.ide.feedback.RsNewsLetterConsentBoxBlock;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/rust/ide/feedback/RsFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/CommonBlockBasedFeedbackDialogWithEmail;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "zendeskTicketTitle", "", "getZendeskTicketTitle", "()Ljava/lang/String;", "zendeskFeedbackType", "getZendeskFeedbackType", "myFeedbackReportId", "getMyFeedbackReportId", "myTitle", "getMyTitle", "myKindOfDevelopmentComboBox", "Lorg/rust/ide/feedback/RsComboBoxBlock;", "myNewsLetterConsentBoxBlock", "Lorg/rust/ide/feedback/RsNewsLetterConsentBoxBlock;", "myBlocks", "", "Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "getMyBlocks", "()Ljava/util/List;", "sendFeedbackData", "", "showThanksNotification", "getCancelAction", "Ljavax/swing/Action;", "intellij.rustrover.core"})
public final class RsFeedbackDialog
extends CommonBlockBasedFeedbackDialogWithEmail {
    @NotNull
    private final String zendeskTicketTitle;
    @NotNull
    private final String zendeskFeedbackType;
    @NotNull
    private final String myFeedbackReportId;
    @NotNull
    private final String myTitle = RsBundle.INSTANCE.message("feedback.user.dialog.top.title", new Object[0]);
    @NotNull
    private final RsComboBoxBlock myKindOfDevelopmentComboBox;
    @NotNull
    private final RsNewsLetterConsentBoxBlock myNewsLetterConsentBoxBlock;
    @NotNull
    private final List<FeedbackBlock> myBlocks;

    public RsFeedbackDialog(@Nullable Project project, boolean forTest) {
        super(project, forTest);
        this.zendeskTicketTitle = "RustRover in-IDE Feedback";
        this.zendeskFeedbackType = "RustRover User in-IDE Feedback";
        this.myFeedbackReportId = "rustrover_old_user_feedback";
        Object[] objectArray = new String[]{RsBundle.INSTANCE.message("kind.of.development.hobby", new Object[0]), RsBundle.INSTANCE.message("kind.of.development.professional", new Object[0])};
        this.myKindOfDevelopmentComboBox = new RsComboBoxBlock(RsBundle.INSTANCE.message("label.for.what.kind.development.do.you.primarily.use.rustrover", new Object[0]), CollectionsKt.listOf((Object[])objectArray), "development_reason");
        this.myNewsLetterConsentBoxBlock = new RsNewsLetterConsentBoxBlock();
        objectArray = new FeedbackBlock[]{new TopLabelBlock(RsBundle.INSTANCE.message("feedback.user.dialog.title", new Object[0])), new DescriptionBlock(RsBundle.INSTANCE.message("feedback.user.dialog.description", new Object[0])), new RatingBlock(RsBundle.INSTANCE.message("feedback.user.dialog.satisfaction.label", new Object[0]), "satisfaction"), new TextAreaBlock(RsBundle.INSTANCE.message("feedback.user.dialog.like_most.label", new Object[0]), "like_most"), new TextAreaBlock(RsBundle.INSTANCE.message("feedback.user.dialog.problems.label", new Object[0]), "problems_or_missing_features"), this.myKindOfDevelopmentComboBox, this.myNewsLetterConsentBoxBlock};
        this.myBlocks = CollectionsKt.listOf((Object[])objectArray);
        this.init();
    }

    @NotNull
    public String getZendeskTicketTitle() {
        return this.zendeskTicketTitle;
    }

    @NotNull
    public String getZendeskFeedbackType() {
        return this.zendeskFeedbackType;
    }

    @NotNull
    protected String getMyFeedbackReportId() {
        return this.myFeedbackReportId;
    }

    @NotNull
    protected String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    protected List<FeedbackBlock> getMyBlocks() {
        return this.myBlocks;
    }

    protected void sendFeedbackData() {
        if (!this.myNewsLetterConsentBoxBlock.isSelected() && ((CharSequence)this.getEmailBlockWithAgreement().getEmailAddressIfSpecified()).length() == 0) {
            ((RsFeedbackPersistenceState.MyState)RsFeedbackPersistenceState.Companion.getInstance().getState()).setReportedDevelopmentKind(this.myKindOfDevelopmentComboBox.getSelectedIndex());
        }
        super.sendFeedbackData();
    }

    public void showThanksNotification() {
        new ThanksForFeedbackNotification(null, RsBundle.INSTANCE.message("feedback.notification.thanks.feedback.content", new Object[0]), 1, null).notify(this.getMyProject());
    }

    @NotNull
    protected Action getCancelAction() {
        Action cancelAction = super.getCancelAction();
        cancelAction.putValue("Name", RsBundle.INSTANCE.message("feedback.user.dialog.cancel.label", new Object[0]));
        return cancelAction;
    }
}

