/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.feedback;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PlatformUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.feedback.RsFeedbackDialog;
import org.rust.ide.feedback.RsFeedbackPersistenceState;
import org.rust.ide.feedback.RsFirstIdeRunStartupActivityKt;
import org.rust.ide.notifications.RsNotifications;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/rust/ide/feedback/IdleFeedbackTypeResolver;", "", "<init>", "()V", "lastActivityTime", "Ljava/time/LocalDateTime;", "checkActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsShowFeedbackDialogMouseListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsShowFeedbackDialogMouseListener.kt\norg/rust/ide/feedback/IdleFeedbackTypeResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class IdleFeedbackTypeResolver {
    @NotNull
    public static final IdleFeedbackTypeResolver INSTANCE = new IdleFeedbackTypeResolver();
    @NotNull
    private static LocalDateTime lastActivityTime;

    private IdleFeedbackTypeResolver() {
    }

    public final void checkActivity(@Nullable Project project) {
        if (!Intrinsics.areEqual((Object)PlatformUtils.getPlatformPrefix(), (Object)"RustRover")) {
            return;
        }
        RsFeedbackPersistenceState instance = RsFeedbackPersistenceState.Companion.getInstance();
        if (((RsFeedbackPersistenceState.MyState)instance.getState()).getFeedbackSent() || ((RsFeedbackPersistenceState.MyState)instance.getState()).getNotificationShowedCount() >= 2) {
            return;
        }
        if (System.currentTimeMillis() < ((RsFeedbackPersistenceState.MyState)instance.getState()).getNextTimeToAskFeedback()) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        if (Duration.between(lastActivityTime, now).toSeconds() >= (long)Registry.Companion.intValue("platform.feedback.time.to.show.notification")) {
            Notification notification = RsNotifications.INSTANCE.createPluginNotification("feedback.form.prompted", (Function1<? super NotificationGroup, ? extends Notification>)((Function1)IdleFeedbackTypeResolver::checkActivity$lambda$0));
            NotificationAction it2 = NotificationAction.createSimpleExpiring((String)RsBundle.INSTANCE.message("notification.content.respond", new Object[0]), () -> IdleFeedbackTypeResolver.checkActivity$lambda$1(project, instance));
            boolean bl = false;
            notification.addAction((AnAction)it2);
            RsFirstIdeRunStartupActivityKt.delayFeedbackPromptInDays(Registry.Companion.intValue("rust.following.delay.after.first.start.before.feedback.prompt"));
            RsFeedbackPersistenceState.MyState myState = (RsFeedbackPersistenceState.MyState)instance.getState();
            int n = myState.getNotificationShowedCount();
            myState.setNotificationShowedCount(n + 1);
            notification.notify(project);
        }
        Intrinsics.checkNotNull((Object)now);
        lastActivityTime = now;
    }

    private static final Notification checkActivity$lambda$0(NotificationGroup it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.createNotification(RsBundle.INSTANCE.message("notification.title.share.feedback.about.rustrover", new Object[0]), RsBundle.INSTANCE.message("notification.content.please.answer.few.questions.it.will.take.about.minutes", new Object[0]), NotificationType.INFORMATION);
    }

    private static final void checkActivity$lambda$1(Project $project, RsFeedbackPersistenceState $instance) {
        RsFeedbackDialog dialog = new RsFeedbackDialog($project, Registry.Companion.is("rust.feedback.test.mode"));
        if (dialog.showAndGet()) {
            ((RsFeedbackPersistenceState.MyState)$instance.getState()).setFeedbackSent(true);
            dialog.showThanksNotification();
        }
    }

    static {
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        lastActivityTime = localDateTime;
    }
}

